/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.lookup.impl;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.lookup.AbstractLookupManager;
import org.kie.workbench.common.stunner.core.lookup.VFSLookupRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.DirectoryStream;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;

@Dependent
@Typed(value={VFSLookupManager.class})
public class VFSLookupManager<T>
extends AbstractLookupManager<T, T, VFSLookupRequest> {
    private static final Logger LOG = LoggerFactory.getLogger((String)VFSLookupManager.class.getName());
    private final VFSService vfsService;
    private Predicate<Path> pathAcceptor;
    private Function<Path, T> itemSupplier;

    protected VFSLookupManager() {
        this.vfsService = null;
        this.pathAcceptor = null;
        this.itemSupplier = null;
    }

    @Inject
    public VFSLookupManager(VFSService vfsService) {
        this.vfsService = vfsService;
        this.pathAcceptor = null;
        this.itemSupplier = null;
    }

    public VFSLookupManager(VFSService vfsService, Predicate<Path> pathAcceptor, Function<Path, T> itemSupplier) {
        this.vfsService = vfsService;
        this.pathAcceptor = pathAcceptor;
        this.itemSupplier = itemSupplier;
    }

    public VFSLookupManager<T> setPathAcceptor(Predicate<Path> pathAcceptor) {
        this.pathAcceptor = pathAcceptor;
        return this;
    }

    public VFSLookupManager<T> setItemSupplier(Function<Path, T> itemSupplier) {
        this.itemSupplier = itemSupplier;
        return this;
    }

    protected List<T> getItems(VFSLookupRequest request) {
        return this.getItemsByPath(request.getPath());
    }

    public List<T> getItemsByPath(Path root) {
        DirectoryStream files = this.vfsService.newDirectoryStream(root, path -> this.pathAcceptor.test((Path)path));
        return StreamSupport.stream(files.spliterator(), false).map(this.itemSupplier).collect(Collectors.toList());
    }

    protected boolean matches(String criteria, T item) {
        return true;
    }

    protected T buildResult(T item) {
        return item;
    }
}

