/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Instance;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.definition.service.DefinitionSetService;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.diagram.DiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingResponse;
import org.kie.workbench.common.stunner.core.registry.BackendRegistryFactory;
import org.kie.workbench.common.stunner.core.registry.diagram.DiagramRegistry;
import org.kie.workbench.common.stunner.core.service.BaseDiagramService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.workbench.type.ResourceTypeDefinition;

public abstract class AbstractVFSDiagramService<M extends Metadata, D extends Diagram<Graph, M>>
implements BaseDiagramService<M, D> {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractVFSDiagramService.class.getName());
    public static final String SVG_SUFFIX = "-svg.svg";
    private final DefinitionManager definitionManager;
    private final FactoryManager factoryManager;
    private final Instance<DefinitionSetService> definitionSetServiceInstances;
    private final BackendRegistryFactory registryFactory;
    private Collection<DefinitionSetService> definitionSetServices = new LinkedList<DefinitionSetService>();
    private DiagramRegistry<D> registry;
    private User identity;

    public AbstractVFSDiagramService(DefinitionManager definitionManager, FactoryManager factoryManager, Instance<DefinitionSetService> definitionSetServiceInstances, BackendRegistryFactory registryFactory, User identity) {
        this.definitionManager = definitionManager;
        this.factoryManager = factoryManager;
        this.definitionSetServiceInstances = definitionSetServiceInstances;
        this.registryFactory = registryFactory;
        this.identity = identity;
    }

    protected abstract IOService getIoService();

    protected void initialize() {
        for (DefinitionSetService definitionSetService : this.definitionSetServiceInstances) {
            this.definitionSetServices.add(definitionSetService);
        }
        this.registry = this.registryFactory.newDiagramSynchronizedRegistry();
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path path, String name, String defSetId, Metadata metadata) {
        DefinitionSetService services = this.getServiceById(defSetId);
        if (null == services) {
            throw new IllegalStateException("No backend Definition Set services for [" + defSetId + "]");
        }
        String fName = this.buildFileName(name, (ResourceTypeDefinition)services.getResourceType());
        Path kiePath = this.convertToNioPath(path).resolve(fName);
        if (this.getIoService().exists(kiePath)) {
            throw new FileAlreadyExistsException(kiePath.toString());
        }
        try {
            Diagram diagram = this.factoryManager.newDiagram(name, defSetId, metadata);
            String[] raw = this.serialize(diagram);
            this.getIoService().write(kiePath, raw[0], new OpenOption[]{new CommentedOption(this.identity.getIdentifier())});
            return this.convertToBackendPath(kiePath);
        }
        catch (Exception e) {
            LOG.error("Cannot create diagram in path [" + kiePath + "]", (Throwable)e);
            return null;
        }
    }

    public String getRawContent(D diagram) {
        try {
            return this.serialize(diagram)[0];
        }
        catch (java.io.IOException e) {
            LOG.error("Error while getting raw content for diagram with UUID [" + diagram.getName() + "].", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract Class<? extends Metadata> getMetadataType();

    private String buildFileName(String baseFileName, ResourceTypeDefinition resourceType) {
        String extension;
        String suffix = resourceType.getSuffix();
        String prefix = resourceType.getPrefix();
        String string = extension = suffix != null && !"".equals(suffix) ? "." + resourceType.getSuffix() : "";
        if (baseFileName.endsWith(extension)) {
            return prefix + baseFileName;
        }
        return prefix + baseFileName + extension;
    }

    public D getDiagramByPath(org.uberfire.backend.vfs.Path file) {
        DefinitionSetService services;
        if (this.accepts(file) && null != (services = this.getServiceByPath(file))) {
            String defSetId = this.getDefinitionSetId(services);
            String name = this.parseFileName(file, services);
            Metadata metadata = this.buildMetadataInstance(file, defSetId, name);
            metadata.setPath(file);
            InputStream is = this.loadPath(file);
            try {
                MarshallingResponse marshallingResponse = services.getDiagramMarshaller().unmarshallWithValidation(MarshallingRequest.builder().metadata(metadata).input((Object)is).mode(MarshallingRequest.Mode.AUTO).build());
                Graph graph = (Graph)Optional.ofNullable(marshallingResponse.getResult()).orElseThrow(() -> new RuntimeException(marshallingResponse.getMessages().toString()));
                DiagramFactory factory = this.factoryManager.registry().getDiagramFactory((String)((DefinitionSet)graph.getContent()).getDefinition(), this.getMetadataType());
                return (D)factory.build(name, metadata, graph);
            }
            catch (Exception e) {
                LOG.error("Cannot unmarshall diagram for diagram's path [" + file + "]", (Throwable)e);
                String xml = this.getIoService().readAllString(this.convertToNioPath(file));
                throw new DiagramParsingException(metadata, xml);
            }
        }
        throw new UnsupportedOperationException("Diagram format not supported [" + file + "]");
    }

    private String parseFileName(org.uberfire.backend.vfs.Path file, DefinitionSetService services) {
        String ext;
        String n = file.getFileName();
        if (!n.endsWith(ext = services.getResourceType().getSuffix())) {
            throw new RuntimeException("File [" + n + "] should have the suffix [" + ext + "]");
        }
        return n.substring(0, n.length() - ext.length() - 1);
    }

    public M saveOrUpdate(D diagram) {
        return this.register(diagram);
    }

    public org.uberfire.backend.vfs.Path saveOrUpdateSvg(org.uberfire.backend.vfs.Path diagramPath, String rawDiagramSvg) {
        Path svgPath = this.getDiagramSvgFilePath((Diagram)this.getDiagramByPath(diagramPath));
        LOG.info("Saving diagram SVG " + svgPath);
        this.getIoService().write(svgPath, rawDiagramSvg, new OpenOption[]{new CommentedOption(this.identity.getIdentifier())});
        return this.convertToBackendPath(svgPath);
    }

    protected Path getDiagramSvgFilePath(Diagram diagram) {
        Path diagramFilePath = this.convertToNioPath(diagram.getMetadata().getPath());
        String fileName = this.getDiagramSvgFileName(diagram);
        return diagramFilePath.getParent().resolve(fileName);
    }

    private String getDiagramSvgFileName(Diagram diagram) {
        DefinitionAdapter definitionAdapter = this.definitionManager.adapters().forDefinition();
        Object pojo = ((Definition)diagram.getGraph().getNode(diagram.getMetadata().getCanvasRootUUID()).getContent()).getDefinition();
        String metaPropertyField = definitionAdapter.getMetaPropertyField(pojo, PropertyMetaTypes.ID);
        Object metaProperty = definitionAdapter.getProperty(pojo, metaPropertyField).get();
        Object diagramFileId = this.definitionManager.adapters().forProperty().getValue(metaProperty);
        return String.valueOf(diagramFileId).concat(SVG_SUFFIX);
    }

    public boolean delete(D diagram) {
        org.uberfire.backend.vfs.Path path = diagram.getMetadata().getPath();
        return this.doDelete(path);
    }

    protected abstract boolean doDelete(org.uberfire.backend.vfs.Path var1);

    protected abstract M doSave(D var1, String var2, String var3);

    private M register(D diagram) {
        try {
            String[] raw = this.serialize(diagram);
            return this.doSave(diagram, raw[0], raw[1]);
        }
        catch (Exception e) {
            LOG.error("Error while saving diagram with UUID [" + diagram.getName() + "].", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String[] serialize(D diagram) throws java.io.IOException {
        String defSetId = diagram.getMetadata().getDefinitionSetId();
        DefinitionSetService services = this.getServiceById(defSetId);
        DiagramMarshaller marshaller = services.getDiagramMarshaller();
        String rawData = marshaller.marshall(diagram);
        Metadata metadata = diagram.getMetadata();
        String metadataRaw = marshaller.getMetadataMarshaller().marshall(metadata);
        return new String[]{rawData, metadataRaw};
    }

    public boolean contains(D item) {
        return null != this.getDiagramByPath(item.getMetadata().getPath());
    }

    public Collection<D> getDiagramsByPath(Path root) {
        try {
            final ArrayList result = new ArrayList();
            if (this.getIoService().exists(root)) {
                this.walkFileTree(root, new SimpleFileVisitor<Path>(){

                    public FileVisitResult visitFile(Path _file, BasicFileAttributes attrs) throws IOException {
                        PortablePreconditions.checkNotNull((String)"file", (Object)_file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        org.uberfire.backend.vfs.Path file = AbstractVFSDiagramService.this.convertToBackendPath(_file);
                        if (AbstractVFSDiagramService.this.accepts(file)) {
                            try {
                                Object diagram = AbstractVFSDiagramService.this.getDiagramByPath(file);
                                if (null != diagram) {
                                    result.add(diagram);
                                }
                            }
                            catch (Exception e) {
                                LOG.error("Error getting diagram for path {}", (Object)file, (Object)e);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return result;
        }
        catch (Exception e) {
            LOG.error("Error while obtaining diagrams.", (Throwable)e);
            throw e;
        }
    }

    protected void walkFileTree(Path root, SimpleFileVisitor<Path> fileVisitor) {
        Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)root)), fileVisitor);
    }

    protected org.uberfire.backend.vfs.Path convertToBackendPath(Path path) {
        return Paths.convert((Path)path);
    }

    protected Path convertToNioPath(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }

    protected abstract Metadata buildMetadataInstance(org.uberfire.backend.vfs.Path var1, String var2, String var3);

    protected InputStream loadPath(org.uberfire.backend.vfs.Path _path) {
        Path path = this.convertToNioPath(_path);
        byte[] bytes = this.getIoService().readAllBytes(path);
        return new ByteArrayInputStream(bytes);
    }

    public boolean accepts(org.uberfire.backend.vfs.Path path) {
        if (path != null) {
            for (DefinitionSetService definitionSetService : this.definitionSetServices) {
                if (!definitionSetService.getResourceType().accept(path)) continue;
                return true;
            }
        }
        return false;
    }

    protected Set<String> getExtensionsAccepted() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (DefinitionSetService definitionSetService : this.definitionSetServices) {
            result.add(definitionSetService.getResourceType().getSuffix());
        }
        return result;
    }

    protected DefinitionSetService getServiceByPath(org.uberfire.backend.vfs.Path path) {
        for (DefinitionSetService definitionSetService : this.definitionSetServices) {
            if (!definitionSetService.getResourceType().accept(path)) continue;
            return definitionSetService;
        }
        return null;
    }

    protected String getDefinitionSetId(DefinitionSetService services) {
        Class type = services.getResourceType().getDefinitionSetType();
        return BindableAdapterUtils.getDefinitionSetId((Class)type);
    }

    protected DefinitionSetService getServiceById(String defSetId) {
        for (DefinitionSetService definitionSetService : this.definitionSetServices) {
            if (!definitionSetService.accepts(defSetId)) continue;
            return definitionSetService;
        }
        return null;
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    protected DiagramRegistry<D> getRegistry() {
        return this.registry;
    }
}

