/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.net.MalformedURLException;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.ArtifactResolver;
import org.appformer.maven.integration.DependencyDescriptor;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.integration.PomParser;
import org.appformer.maven.integration.embedder.EmbeddedPomParser;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.DependencyFilter;
import org.eclipse.aether.artifact.Artifact;

public class DefaultArtifactResolver
extends ArtifactResolver {
    private final MavenRepository mavenRepository;
    protected final PomParser pomParser;

    DefaultArtifactResolver() {
        this.pomParser = new EmbeddedPomParser();
        this.mavenRepository = MavenRepository.getMavenRepository();
    }

    DefaultArtifactResolver(MavenProject mavenProject) {
        this.pomParser = new EmbeddedPomParser(mavenProject);
        this.mavenRepository = MavenRepository.getMavenRepository(mavenProject);
    }

    DefaultArtifactResolver(PomParser pomParser) {
        this.pomParser = pomParser;
        this.mavenRepository = MavenRepository.getMavenRepository();
    }

    @Override
    public Artifact resolveArtifact(AFReleaseId releaseId) {
        return this.mavenRepository.resolveArtifact(releaseId);
    }

    @Override
    public List<DependencyDescriptor> getArtifactDependecies(String artifactName) {
        return this.mavenRepository.getArtifactDependecies(artifactName);
    }

    @Override
    public List<DependencyDescriptor> getPomDirectDependencies(DependencyFilter dependencyFilter) {
        return this.pomParser.getPomDirectDependencies(dependencyFilter);
    }

    @Override
    public ArtifactResolver.ArtifactLocation resolveArtifactLocation(AFReleaseId releaseId) {
        try {
            Artifact artifact = this.resolveArtifact(releaseId);
            if (artifact == null) {
                return null;
            }
            return new ArtifactResolver.ArtifactLocation(artifact, artifact.getFile().toURL(), false);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

