/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.projecteditor.backend.server;

import java.io.IOException;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.ModuleRepositories;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ModuleRepositoriesService;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.defaulteditor.service.DefaultEditorContent;
import org.kie.workbench.common.screens.defaulteditor.service.DefaultEditorService;
import org.kie.workbench.common.screens.projecteditor.model.InvalidPomException;
import org.kie.workbench.common.screens.projecteditor.service.PomEditorService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class PomEditorServiceImpl
implements PomEditorService {
    private static final String UNDETERMINED = "<undetermined>";
    private static final GAV GAV_UNDETERMINED = new GAV("<undetermined>", "<undetermined>", "<undetermined>");
    private static final Logger logger = LoggerFactory.getLogger(PomEditorServiceImpl.class);
    private IOService ioService;
    private DefaultEditorService defaultEditorService;
    private MetadataServerSideService metadataService;
    private CommentedOptionFactory commentedOptionFactory;
    private KieModuleService moduleService;
    private POMContentHandler pomContentHandler;
    private ModuleRepositoryResolver repositoryResolver;
    private ModuleRepositoriesService moduleRepositoriesService;
    private RenameService renameService;
    private SaveAndRenameServiceImpl<String, Metadata> saveAndRenameService;

    public PomEditorServiceImpl() {
    }

    @Inject
    public PomEditorServiceImpl(@Named(value="ioStrategy") IOService ioService, DefaultEditorService defaultEditorService, MetadataServerSideService metadataService, CommentedOptionFactory commentedOptionFactory, KieModuleService moduleService, POMContentHandler pomContentHandler, ModuleRepositoryResolver repositoryResolver, ModuleRepositoriesService moduleRepositoriesService, RenameService renameService, SaveAndRenameServiceImpl<String, Metadata> saveAndRenameService) {
        this.ioService = ioService;
        this.defaultEditorService = defaultEditorService;
        this.metadataService = metadataService;
        this.commentedOptionFactory = commentedOptionFactory;
        this.moduleService = moduleService;
        this.pomContentHandler = pomContentHandler;
        this.repositoryResolver = repositoryResolver;
        this.moduleRepositoriesService = moduleRepositoriesService;
        this.renameService = renameService;
        this.saveAndRenameService = saveAndRenameService;
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public DefaultEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        return this.defaultEditorService.loadContent(path);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path pomPath, String pomXml, Metadata metadata, String comment, DeploymentMode mode) {
        if (DeploymentMode.VALIDATED.equals((Object)mode)) {
            this.checkRepositories(pomPath, pomXml);
        }
        try {
            Path nioPomPath = Paths.convert((org.uberfire.backend.vfs.Path)pomPath);
            this.ioService.startBatch(nioPomPath.getFileSystem());
            this.ioService.write(nioPomPath, pomXml, this.metadataService.setUpAttributes(pomPath, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            org.uberfire.backend.vfs.Path path = pomPath;
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private void checkRepositories(org.uberfire.backend.vfs.Path pomPath, String pomXml) {
        KieModule module = (KieModule)this.moduleService.resolveModule(pomPath);
        POM pom = new POM(GAV_UNDETERMINED);
        try {
            pom = this.pomContentHandler.toModel(pomXml);
            if (pom.getGav().equals((Object)module.getPom().getGav())) {
                return;
            }
            if (pom.getGav().isSnapshot()) {
                return;
            }
        }
        catch (XmlPullParserException e) {
            throw new InvalidPomException(e.getLineNumber(), e.getColumnNumber());
        }
        catch (IOException e) {
            logger.warn("Unable to load pom.xml. It is therefore impossible to ascertain GAV.", (Throwable)e);
        }
        ModuleRepositories moduleRepositories = (ModuleRepositories)this.moduleRepositoriesService.load(module.getRepositoriesPath());
        Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(pomXml, moduleRepositories.filterByIncluded());
        if (repositories.size() > 0) {
            throw new GAVAlreadyExistsException(pom.getGav(), repositories);
        }
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, String content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, String content, Metadata metadata, String comment) {
        return this.save(path, content, metadata, comment, DeploymentMode.FORCED);
    }
}

