/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.entrypoint;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.HTMLTextAreaElement;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.workbench.client.error.GenericErrorTimeController;
import org.kie.workbench.common.workbench.client.error.TimeAmount;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.client.util.Clipboard;
import org.uberfire.ext.editor.commons.client.file.popups.elemental2.Elemental2Modal;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Templated
@ApplicationScoped
public class GenericErrorPopup
extends Elemental2Modal<GenericErrorPopup>
implements Elemental2Modal.View<GenericErrorPopup> {
    @Inject
    @DataField(value="header")
    private HTMLDivElement header;
    @Inject
    @DataField(value="body")
    private HTMLDivElement body;
    @Inject
    @DataField(value="footer")
    private HTMLDivElement footer;
    @Inject
    @DataField(value="continue-button")
    private HTMLButtonElement continueButton;
    @Inject
    @DataField(value="error-details-section")
    private HTMLDivElement errorDetailsSection;
    @Inject
    @DataField(value="error-details")
    private HTMLTextAreaElement errorDetails;
    @Inject
    @DataField(value="chevron-right")
    private HTMLAnchorElement chevronRight;
    @Inject
    @DataField(value="chevron-down")
    private HTMLAnchorElement chevronDown;
    @Inject
    @DataField(value="time-select")
    private HTMLSelectElement timeSelect;
    @Inject
    @Named(value="span")
    @DataField(value="error-id")
    private HTMLElement errorId;
    @Inject
    @Named(value="span")
    @DataField(value="unresolved-errors-tooltip")
    private HTMLElement tooltip;
    @Inject
    @DataField(value="do-not-show-again-checkbox")
    private HTMLInputElement doNotShowAgainCheckbox;
    @Inject
    @DataField(value="copy-details")
    private HTMLAnchorElement copyDetails;
    private final Clipboard clipboard;
    private final Event<NotificationEvent> notificationEvent;
    private final GenericErrorTimeController genericErrorTimeController;
    private final TranslationService ts;
    private Command onClose = () -> {};

    @Inject
    public GenericErrorPopup(GenericErrorPopup view, Clipboard clipboard, Event<NotificationEvent> notificationEvent, GenericErrorTimeController genericErrorTimeController, TranslationService ts) {
        super((Elemental2Modal.View)view);
        this.clipboard = clipboard;
        this.notificationEvent = notificationEvent;
        this.genericErrorTimeController = genericErrorTimeController;
        this.ts = ts;
    }

    @PostConstruct
    public void init() {
        super.setup();
        this.getModal().addHiddenHandler(e -> {
            this.errorDetails.textContent = "";
        });
    }

    public void init(GenericErrorPopup this_) {
    }

    public void setup(String details) {
        this.setup(details, () -> {}, null);
    }

    public void setup(String details, Command onClose) {
        this.setup(details, onClose, null);
    }

    public void setup(String details, Command onClose, String errorId) {
        this.showErrorDetails(false);
        this.tooltip.title = this.ts.getTranslation("GenericErrorPopup.TimeSelectionTooltip");
        this.timeSelect.value = TimeAmount.TEN_MINUTES.name();
        this.doNotShowAgainCheckbox.checked = false;
        this.onClose = onClose;
        this.errorDetails.textContent = this.isShowing() && !this.errorDetails.textContent.equals("") ? this.errorDetails.textContent + " | " + details : details;
        this.errorId.textContent = errorId != null ? this.ts.format("GenericErrorPopup.ErrorId", new Object[]{errorId}) : "";
    }

    public void close() {
        this.hide();
        this.onClose.execute();
    }

    @EventHandler(value={"chevron-right"})
    public void onChevronRightClicked(ClickEvent event) {
        this.showErrorDetails(true);
    }

    @EventHandler(value={"chevron-down"})
    public void onChevronDownClicked(ClickEvent event) {
        this.showErrorDetails(false);
    }

    private void showErrorDetails(boolean isVisible) {
        this.chevronRight.hidden = isVisible;
        this.chevronDown.hidden = !isVisible;
        this.errorDetailsSection.hidden = !isVisible;
    }

    @EventHandler(value={"copy-details"})
    public void onCopyDetailsClicked(ClickEvent event) {
        this.showErrorDetails(true);
        boolean copySucceeded = this.clipboard.copy(this.errorDetails);
        if (copySucceeded) {
            this.notificationEvent.fire((Object)new NotificationEvent(DefaultWorkbenchConstants.INSTANCE.ErrorDetailsSuccessfullyCopiedToClipboard(), NotificationEvent.NotificationType.SUCCESS));
        } else {
            this.notificationEvent.fire((Object)new NotificationEvent(DefaultWorkbenchConstants.INSTANCE.ErrorDetailsFailedToBeCopiedToClipboard(), NotificationEvent.NotificationType.WARNING));
        }
        DomGlobal.console.error(new Object[]{this.errorDetails.textContent});
    }

    @EventHandler(value={"continue-button"})
    public void onContinueButtonClicked(ClickEvent event) {
        DomGlobal.console.error(new Object[]{this.errorDetails.textContent});
        if (this.doNotShowAgainCheckbox.checked) {
            TimeAmount duration = TimeAmount.valueOf(this.timeSelect.value);
            this.genericErrorTimeController.setTimeout(duration);
        }
        this.close();
    }

    public String getHeader() {
        return this.header.textContent;
    }

    public HTMLElement getBody() {
        return this.body;
    }

    public HTMLElement getFooter() {
        return this.footer;
    }
}

