/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scorecardxls.backend.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.drools.workbench.screens.scorecardxls.backend.server.ExtendedScoreCardXLSService;
import org.drools.workbench.screens.scorecardxls.service.ScoreCardXLSContent;
import org.drools.workbench.screens.scorecardxls.service.ScoreCardXLSService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.kie.workbench.common.services.backend.service.KieService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class ScoreCardXLSServiceImpl
extends KieService<ScoreCardXLSContent>
implements ScoreCardXLSService,
ExtendedScoreCardXLSService {
    private static final Logger log = LoggerFactory.getLogger(ScoreCardXLSServiceImpl.class);
    private IOService ioService;
    private CopyService copyService;
    private DeleteService deleteService;
    private RenameService renameService;
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    private GenericValidator genericValidator;
    private CommentedOptionFactory commentedOptionFactory;
    private AuthenticationService authenticationService;

    public ScoreCardXLSServiceImpl() {
    }

    @Inject
    public ScoreCardXLSServiceImpl(@Named(value="ioStrategy") IOService ioService, CopyService copyService, DeleteService deleteService, RenameService renameService, Event<ResourceOpenedEvent> resourceOpenedEvent, GenericValidator genericValidator, CommentedOptionFactory commentedOptionFactory, AuthenticationService authenticationService) {
        this.ioService = ioService;
        this.copyService = copyService;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.resourceOpenedEvent = resourceOpenedEvent;
        this.genericValidator = genericValidator;
        this.commentedOptionFactory = commentedOptionFactory;
        this.authenticationService = authenticationService;
    }

    public ScoreCardXLSContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (ScoreCardXLSContent)super.loadContent(path);
    }

    protected ScoreCardXLSContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        ScoreCardXLSContent content = new ScoreCardXLSContent();
        content.setOverview(overview);
        return content;
    }

    @Override
    public InputStream load(org.uberfire.backend.vfs.Path path, String sessionId) {
        try {
            InputStream inputStream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[]{StandardOpenOption.READ});
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.getSessionInfo(sessionId)));
            return inputStream;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    @Override
    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path resource, InputStream content, String sessionId, String comment) {
        return this.writeToFile(resource, content, sessionId, comment, true);
    }

    @Override
    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, InputStream content, String sessionId, String comment) {
        return this.writeToFile(resource, content, sessionId, comment, false);
    }

    private org.uberfire.backend.vfs.Path writeToFile(org.uberfire.backend.vfs.Path resource, InputStream content, String sessionId, String comment, boolean create) {
        SessionInfo sessionInfo = this.getSessionInfo(sessionId);
        String userAction = "UPDATING";
        if (create) {
            userAction = "CREATING";
        }
        log.info("USER:" + sessionInfo.getIdentity().getIdentifier() + " " + userAction + " asset [" + resource.getFileName() + "]");
        OutputStream outputStream = null;
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)resource);
            if (create) {
                this.ioService.createFile(nioPath, new FileAttribute[0]);
            }
            outputStream = this.ioService.newOutputStream(nioPath, new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment, sessionInfo.getIdentity(), sessionInfo)});
            IOUtils.copy((InputStream)content, (OutputStream)outputStream);
            outputStream.flush();
            org.uberfire.backend.vfs.Path path = resource;
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw ExceptionUtilities.handleException((Exception)e);
                }
            }
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, org.uberfire.backend.vfs.Path resource) {
        try {
            return this.genericValidator.validate(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private SessionInfo getSessionInfo(String sessionId) {
        return new SafeSessionInfo((SessionInfo)new SessionInfoImpl(sessionId, this.authenticationService.getUser()));
    }
}

