/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.stunner.bpmn.project.backend.query.FindBpmnProcessIdsQuery;
import org.kie.workbench.common.stunner.bpmn.project.service.ProjectOpenReusableSubprocessService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
@Service
public class ProjectOpenReusableSubprocessServiceImpl
implements ProjectOpenReusableSubprocessService {
    private final RefactoringQueryService queryService;
    private final Supplier<ResourceType> resourceType;
    private final Supplier<String> queryName;
    private final Set<ValueIndexTerm> queryTerms;

    protected ProjectOpenReusableSubprocessServiceImpl() {
        this(null);
    }

    @Inject
    public ProjectOpenReusableSubprocessServiceImpl(RefactoringQueryService queryService) {
        this.queryService = queryService;
        this.resourceType = () -> ResourceType.BPMN2;
        this.queryName = () -> FindBpmnProcessIdsQuery.NAME;
        this.queryTerms = new Sets.Builder().add((Object)new ValueResourceIndexTerm("*", this.resourceType.get(), ValueIndexTerm.TermSearchType.WILDCARD)).build();
    }

    String getQueryName() {
        return this.queryName.get();
    }

    Set<ValueIndexTerm> createQueryTerms() {
        return this.queryTerms;
    }

    public List<String> openReusableSubprocess(String processId) {
        ArrayList<String> answer = new ArrayList<String>();
        Map subprocesses = this.queryService.query(this.getQueryName(), this.createQueryTerms()).stream().map(row -> (Map)row.getValue()).filter(row -> row.get(processId) != null).findFirst().orElse(null);
        if (subprocesses == null) {
            return answer;
        }
        answer.add(((Path)subprocesses.get(processId)).getFileName());
        answer.add(((Path)subprocesses.get(processId)).toURI());
        return answer;
    }
}

