/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.version;

import java.net.URISyntaxException;
import java.util.List;
import javax.inject.Inject;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordService;
import org.uberfire.ext.editor.commons.backend.version.VersionUtil;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;

public class PathResolverImpl
implements PathResolver {
    private VersionRecordService versionLoader;
    private VersionUtil util;

    public PathResolverImpl() {
    }

    @Inject
    public PathResolverImpl(VersionRecordService versionLoader, VersionUtil util) {
        this.util = util;
        this.versionLoader = versionLoader;
    }

    public Path resolveMainFilePath(Path path) throws URISyntaxException {
        if (this.isDotFile(path)) {
            Path mainPath = this.getMainPath(path);
            VersionRecord currentMainRecord = this.versionLoader.loadRecord(path);
            List versionRecords = this.versionLoader.loadVersionRecords(mainPath);
            for (VersionRecord versionRecord : versionRecords) {
                if (versionRecord.date().compareTo(currentMainRecord.date()) < 0) continue;
                return this.util.getPath(mainPath, versionRecord.id());
            }
            return mainPath;
        }
        return path;
    }

    private Path getMainPath(Path path) {
        return path.resolveSibling(this.util.getFileName(path).substring(1));
    }

    public boolean isDotFile(Path path) {
        return this.util.getFileName(path).startsWith(".");
    }
}

