/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.editor.service.shared.model.impl;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.forms.commons.shared.layout.FormLayoutTemplateGenerator;
import org.kie.workbench.common.forms.editor.model.FormModelSynchronizationResult;
import org.kie.workbench.common.forms.editor.model.TypeConflict;
import org.kie.workbench.common.forms.editor.service.shared.model.FormModelSynchronizationUtil;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.forms.service.shared.FieldManager;

@Dependent
public class FormModelSynchronizationUtilImpl
implements FormModelSynchronizationUtil {
    private static Logger logger = Logger.getLogger(FormModelSynchronizationUtilImpl.class.getName());
    private FieldManager fieldManager;
    private FormLayoutTemplateGenerator formLayoutTemplateGenerator;
    private FormDefinition form;
    private FormModelSynchronizationResult synchronizationResult;

    @Inject
    public FormModelSynchronizationUtilImpl(FieldManager fieldManager, FormLayoutTemplateGenerator formLayoutTemplateGenerator) {
        this.fieldManager = fieldManager;
        this.formLayoutTemplateGenerator = formLayoutTemplateGenerator;
    }

    @Override
    public void init(FormDefinition form, FormModelSynchronizationResult synchronizationResult) {
        PortablePreconditions.checkNotNull((String)"form", (Object)form);
        PortablePreconditions.checkNotNull((String)"synchronizationResult", (Object)synchronizationResult);
        this.form = form;
        this.synchronizationResult = synchronizationResult;
    }

    @Override
    public void fixRemovedFields() {
        if (this.synchronizationResult.hasRemovedProperties()) {
            this.synchronizationResult.getRemovedProperties().forEach(this::unBindField);
        }
    }

    protected void unBindField(ModelProperty removedProperty) {
        Optional<FieldDefinition> optional = Optional.ofNullable(this.form.getFieldByBinding(removedProperty.getName()));
        if (optional.isPresent()) {
            optional.get().setBinding(null);
            logger.warning("Variable '" + removedProperty.getName() + "' has been removed from the Process/Task. Unbinding form field to avoid conflicts during runtime.");
        }
    }

    @Override
    public void resolveConflicts() {
        if (this.synchronizationResult.hasConflicts()) {
            this.synchronizationResult.getPropertyConflicts().forEach(this::resolveConflict);
        }
    }

    protected void resolveConflict(TypeConflict typeConflict) {
        Optional<FieldDefinition> originalformFieldOptional = Optional.ofNullable(this.form.getFieldByBinding(typeConflict.getPropertyName()));
        if (originalformFieldOptional.isPresent()) {
            FieldDefinition originalFormField = originalformFieldOptional.get();
            logger.warning("Conflict found on variable '" + typeConflict.getPropertyName() + "', previous type was '" + typeConflict.getBefore().getClassName() + "' and new one is '" + typeConflict.getNow().getClassName() + "'. Trying to fix.");
            Optional<FieldDefinition> newFieldOptional = Optional.ofNullable(this.fieldManager.getFieldFromProvider(originalFormField.getFieldType().getTypeName(), typeConflict.getNow()));
            FieldDefinition newField = newFieldOptional.isPresent() ? newFieldOptional.get() : this.fieldManager.getDefinitionByDataType(typeConflict.getNow());
            newField.setId(originalFormField.getId());
            newField.setName(originalFormField.getName());
            newField.copyFrom(originalFormField);
            newField.setStandaloneClassName(typeConflict.getNow().getClassName());
            this.form.getFields().remove(originalFormField);
            this.form.getFields().add(newField);
        }
    }

    @Override
    public void addNewFields() {
        this.addNewFields(arg_0 -> ((FieldManager)this.fieldManager).getDefinitionByModelProperty(arg_0));
    }

    @Override
    public void addNewFields(Function<ModelProperty, FieldDefinition> fieldProviderFunction) {
        if (this.synchronizationResult.hasNewProperties()) {
            this.synchronizationResult.getNewProperties().forEach(newProperty -> this.addNewField((ModelProperty)newProperty, fieldProviderFunction));
            List newFields = this.synchronizationResult.getNewProperties().stream().map(arg_0 -> ((FormDefinition)this.form).getFieldByBoundProperty(arg_0)).collect(Collectors.toList());
            this.formLayoutTemplateGenerator.updateLayoutTemplate(this.form, newFields);
        }
    }

    protected void addNewField(ModelProperty newProperty, Function<ModelProperty, FieldDefinition> fieldProviderFunction) {
        if (!Optional.ofNullable(this.form.getFieldByBinding(newProperty.getName())).isPresent()) {
            logger.info("Adding new form field for variable '" + newProperty.getName() + "'.");
            FieldDefinition newField = fieldProviderFunction.apply(newProperty);
            this.form.getFields().add(newField);
        }
    }
}

