/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceProviderFactory;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.service.DataSourceServicesHelper;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDefInfo;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDefInfo;
import org.kie.workbench.common.screens.datasource.management.model.DriverDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefQueryService;
import org.kie.workbench.common.screens.datasource.management.util.DataSourceDefSerializer;
import org.kie.workbench.common.screens.datasource.management.util.DriverDefSerializer;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class DataSourceDefQueryServiceImpl
implements DataSourceDefQueryService {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceDefQueryServiceImpl.class);
    private static String DS_FILE_TYPE = ".datasource";
    private static String DRIVER_FILE_TYPE = ".driver";
    private IOService ioService;
    private KieModuleService moduleService;
    private DataSourceServicesHelper serviceHelper;
    private DataSourceProviderFactory providerFactory;
    private DataSourceRuntimeManager runtimeManager;

    public DataSourceDefQueryServiceImpl() {
    }

    @Inject
    public DataSourceDefQueryServiceImpl(@Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, DataSourceServicesHelper serviceHelper, DataSourceProviderFactory providerFactory, DataSourceRuntimeManager runtimeManager) {
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.serviceHelper = serviceHelper;
        this.providerFactory = providerFactory;
        this.runtimeManager = runtimeManager;
    }

    public Collection<DataSourceDefInfo> findGlobalDataSources(boolean includeUnManaged) {
        Collection<DataSourceDefInfo> result = this.resolveDataSources(this.serviceHelper.getGlobalDataSourcesContext());
        if (includeUnManaged) {
            HashMap<String, DataSourceDefInfo> managedDataSources = new HashMap<String, DataSourceDefInfo>();
            for (DataSourceDefInfo dataSourceDefInfo : result) {
                managedDataSources.put(dataSourceDefInfo.getUuid(), dataSourceDefInfo);
            }
            try {
                List<DataSourceDef> allDeployments = this.providerFactory.getDataSourceProvider().getDeployments();
                for (DataSourceDef dataSourceDef : allDeployments) {
                    DataSourceDeploymentInfo deploymentInfo = this.runtimeManager.getDataSourceDeploymentInfo(dataSourceDef.getUuid());
                    if (managedDataSources.containsKey(dataSourceDef.getUuid()) || deploymentInfo == null || deploymentInfo.isManaged()) continue;
                    result.add(new DataSourceDefInfo(dataSourceDef.getUuid(), dataSourceDef.getName(), this.runtimeManager.getDataSourceDeploymentInfo(dataSourceDef.getUuid())));
                }
            }
            catch (Exception e) {
                logger.warn("It was not possible to read all deployed data sources. ", (Throwable)e);
            }
        }
        return result;
    }

    public Collection<DataSourceDefInfo> findModuleDataSources(org.uberfire.backend.vfs.Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        Module module = this.moduleService.resolveModule(path);
        if (module == null) {
            return new ArrayList<DataSourceDefInfo>();
        }
        return this.resolveDataSources(this.serviceHelper.getModuleDataSourcesContext(module));
    }

    public Collection<DataSourceDefInfo> findModuleDataSources(Module module) {
        if (module != null) {
            return this.resolveDataSources(this.serviceHelper.getModuleDataSourcesContext(module));
        }
        return new ArrayList<DataSourceDefInfo>();
    }

    public Collection<DriverDefInfo> findGlobalDrivers() {
        return this.resolveDrivers(this.serviceHelper.getGlobalDataSourcesContext());
    }

    public Collection<DriverDefInfo> findModuleDrivers(org.uberfire.backend.vfs.Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        Module module = this.moduleService.resolveModule(path);
        if (module == null) {
            return new ArrayList<DriverDefInfo>();
        }
        return this.resolveDrivers(this.serviceHelper.getModuleDataSourcesContext(module));
    }

    public DriverDefInfo findModuleDriver(String uuid, org.uberfire.backend.vfs.Path path) {
        PortablePreconditions.checkNotNull((String)"uuid", (Object)uuid);
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        for (DriverDefInfo driverDefInfo : this.findModuleDrivers(path)) {
            if (!uuid.equals(driverDefInfo.getUuid())) continue;
            return driverDefInfo;
        }
        return null;
    }

    public Collection<DriverDefInfo> findModuleDrivers(Module module) {
        if (module != null) {
            return this.resolveDrivers(this.serviceHelper.getModuleDataSourcesContext(module));
        }
        return new ArrayList<DriverDefInfo>();
    }

    public DriverDefInfo findGlobalDriver(String uuid) {
        PortablePreconditions.checkNotNull((String)"uuid", (Object)uuid);
        for (DriverDefInfo driverDefInfo : this.findGlobalDrivers()) {
            if (!uuid.equals(driverDefInfo.getUuid())) continue;
            return driverDefInfo;
        }
        return null;
    }

    private Collection<DriverDefInfo> resolveDrivers(org.uberfire.backend.vfs.Path path) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        ArrayList<DriverDefInfo> result = new ArrayList<DriverDefInfo>();
        try {
            DirectoryStream stream = this.ioService.newDirectoryStream(nioPath, entry -> Files.isRegularFile((Path)entry, (LinkOption[])new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && entry.getFileName().toString().endsWith(DRIVER_FILE_TYPE));
            stream.forEach(file -> result.add(this.createDriverInfo((Path)file)));
            stream.close();
            return result;
        }
        catch (Exception e) {
            logger.error("It was not possible read drivers info from: " + path, (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Collection<DataSourceDefInfo> resolveDataSources(org.uberfire.backend.vfs.Path path) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        ArrayList<DataSourceDefInfo> result = new ArrayList<DataSourceDefInfo>();
        try {
            DirectoryStream stream = this.ioService.newDirectoryStream(nioPath, entry -> Files.isRegularFile((Path)entry, (LinkOption[])new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && entry.getFileName().toString().endsWith(DS_FILE_TYPE));
            stream.forEach(file -> result.add(this.createDataSourceDefInfo((Path)file)));
            stream.close();
            return result;
        }
        catch (Exception e) {
            logger.error("It was not possible read data sources info from: " + path, (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private DataSourceDefInfo createDataSourceDefInfo(Path path) {
        String content = this.ioService.readAllString(path);
        DataSourceDef dataSourceDef = DataSourceDefSerializer.deserialize(content);
        DataSourceDeploymentInfo deploymentInfo = null;
        try {
            deploymentInfo = this.runtimeManager.getDataSourceDeploymentInfo(dataSourceDef.getUuid());
        }
        catch (Exception e) {
            logger.warn("It was not possible to read deployment info when building DataSourceDefInfo for data source: " + dataSourceDef.getUuid(), (Throwable)e);
        }
        return new DataSourceDefInfo(dataSourceDef.getUuid(), dataSourceDef.getName(), Paths.convert((Path)path), deploymentInfo);
    }

    private DriverDefInfo createDriverInfo(Path path) {
        String content = this.ioService.readAllString(path);
        DriverDef driverDef = DriverDefSerializer.deserialize(content);
        DriverDeploymentInfo deploymentInfo = null;
        try {
            deploymentInfo = this.runtimeManager.getDriverDeploymentInfo(driverDef.getUuid());
        }
        catch (Exception e) {
            logger.warn("It was not possible to read deployment info when building DriverDefInfo for driver: " + driverDef.getUuid(), (Throwable)e);
        }
        return new DriverDefInfo(driverDef.getUuid(), driverDef.getName(), Paths.convert((Path)path), deploymentInfo);
    }
}

