/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing;

import org.drools.compiler.lang.descr.AttributeDescr;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.SharedPart;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.service.PartType;

public class AttributeIndexBuilder {
    private final DefaultIndexBuilder builder;

    public AttributeIndexBuilder(DefaultIndexBuilder builder) {
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
    }

    public void visit(AttributeDescr descr) {
        this.visit(descr.getName(), descr.getValue());
    }

    public void visit(String name, String value) {
        if (this.isIgnored(name)) {
            return;
        }
        PartType type = PartType.getPartTypeFromAttribueDescrName((String)name);
        switch (type) {
            case AGENDA_GROUP: 
            case ACTIVATION_GROUP: 
            case RULEFLOW_GROUP: {
                SharedPart sharedRef = new SharedPart(value, type);
                this.builder.addGenerator((IndexElementsGenerator)sharedRef);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported attribute encountered: " + name);
            }
        }
    }

    public boolean isIgnored(String attr) {
        switch (attr) {
            case "no-loop": 
            case "lock-on-active": 
            case "salience": 
            case "auto-focus": 
            case "dialect": 
            case "date-effective": 
            case "date-expires": 
            case "enabled": 
            case "duration": 
            case "timer": 
            case "calendars": {
                return true;
            }
        }
        return false;
    }
}

