/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreProcess {
    private static final Logger logger = LoggerFactory.getLogger(PreProcess.class);

    private PreProcess() {
    }

    public static List<KiePMMLNameValue> preProcess(KiePMMLModel model, PMMLContext context) {
        PreProcess.addMissingValuesReplacements(model, context);
        PMMLRequestData requestData = context.getRequestData();
        Map mappedRequestParams = requestData.getMappedRequestParams();
        List<KiePMMLNameValue> kiePMMLNameValues = PreProcess.getKiePMMLNameValuesFromParameterInfos(mappedRequestParams.values());
        PreProcess.executeTransformations(model, context, requestData, mappedRequestParams, kiePMMLNameValues);
        return kiePMMLNameValues;
    }

    static void addMissingValuesReplacements(KiePMMLModel model, PMMLContext context) {
        logger.debug("addMissingValuesReplacements {} {}", (Object)model, (Object)context);
        PMMLRequestData requestData = context.getRequestData();
        Map mappedRequestParams = requestData.getMappedRequestParams();
        Map missingValueReplacementMap = model.getMissingValueReplacementMap();
        missingValueReplacementMap.forEach((fieldName, missingValueReplacement) -> {
            if (!mappedRequestParams.containsKey(fieldName)) {
                logger.debug("missingValueReplacement {} {}", fieldName, missingValueReplacement);
                requestData.addRequestParam(fieldName, missingValueReplacement);
                context.addMissingValueReplaced(fieldName, missingValueReplacement);
            }
        });
    }

    static void executeTransformations(KiePMMLModel model, PMMLContext context, PMMLRequestData requestData, Map<String, ParameterInfo> mappedRequestParams, List<KiePMMLNameValue> kiePMMLNameValues) {
        logger.debug("executeTransformations {} {}", (Object)model, (Object)requestData);
        Map commonTransformationsMap = model.getCommonTransformationsMap();
        commonTransformationsMap.forEach((fieldName, transformationFunction) -> {
            if (!mappedRequestParams.containsKey(fieldName)) {
                logger.debug("commonTransformation {} {}", fieldName, transformationFunction);
                Object commonTranformation = transformationFunction.apply(kiePMMLNameValues);
                requestData.addRequestParam(fieldName, commonTranformation);
                context.addCommonTranformation(fieldName, commonTranformation);
                kiePMMLNameValues.add(new KiePMMLNameValue(fieldName, commonTranformation));
            }
        });
        Map localTransformationsMap = model.getLocalTransformationsMap();
        localTransformationsMap.forEach((fieldName, transformationFunction) -> {
            logger.debug("localTransformation {} {}", fieldName, transformationFunction);
            Object localTransformation = transformationFunction.apply(kiePMMLNameValues);
            if (mappedRequestParams.containsKey(fieldName)) {
                ParameterInfo toRemove = (ParameterInfo)mappedRequestParams.get(fieldName);
                requestData.removeRequestParam(toRemove);
            }
            requestData.addRequestParam(fieldName, localTransformation);
            context.addLocalTranformation(fieldName, localTransformation);
        });
    }

    static List<KiePMMLNameValue> getKiePMMLNameValuesFromParameterInfos(Collection<ParameterInfo> parameterInfos) {
        return parameterInfos.stream().map(parameterInfo -> new KiePMMLNameValue(parameterInfo.getName(), parameterInfo.getValue())).collect(Collectors.toList());
    }
}

