/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.validation;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProjectError;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ProjectImportService;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidator;

@ApplicationScoped
public class NameAlreadyExistValidator
extends ImportProjectValidator {
    private ProjectImportService projectImportService;

    public NameAlreadyExistValidator() {
    }

    @Inject
    public NameAlreadyExistValidator(ProjectImportService projectImportService) {
        this.projectImportService = projectImportService;
    }

    protected Optional<ExampleProjectError> getError(OrganizationalUnit ou, ImportProject importProject) {
        if (this.projectImportService.exist(ou, importProject)) {
            String errorPattern = "Project <{1}> already exists in space <{0}>";
            return Optional.of(new ExampleProjectError(NameAlreadyExistValidator.class.getCanonicalName(), errorPattern, new Object[]{ou.getSpace().getName(), importProject.getName()}));
        }
        return Optional.empty();
    }
}

