/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.Map;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.ui.model.ProviderKey;

public class PipelineInputBuilder {
    private String runtimeName;
    private ProviderKey providerKey;
    private Map<String, String> params;

    public static PipelineInputBuilder newInstance() {
        return new PipelineInputBuilder();
    }

    private PipelineInputBuilder() {
    }

    public PipelineInputBuilder withRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
        return this;
    }

    public PipelineInputBuilder withProvider(ProviderKey providerKey) {
        this.providerKey = providerKey;
        return this;
    }

    public PipelineInputBuilder withParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public Input build() {
        Input input = new Input();
        if (this.runtimeName != null) {
            input.put((Object)"runtime-name", (Object)this.runtimeName);
        }
        if (this.providerKey != null) {
            input.put((Object)"provider-name", (Object)this.providerKey.getId());
        }
        if (this.params != null) {
            input.putAll(this.params);
        }
        return input;
    }
}

