/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.QuantityFluentImpl;

public class EmptyDirVolumeSourceFluentImpl<A extends EmptyDirVolumeSourceFluent<A>>
extends BaseFluent<A>
implements EmptyDirVolumeSourceFluent<A> {
    private String medium;
    private QuantityBuilder sizeLimit;

    public EmptyDirVolumeSourceFluentImpl() {
    }

    public EmptyDirVolumeSourceFluentImpl(EmptyDirVolumeSource instance) {
        this.withMedium(instance.getMedium());
        this.withSizeLimit(instance.getSizeLimit());
    }

    @Override
    public String getMedium() {
        return this.medium;
    }

    @Override
    public A withMedium(String medium) {
        this.medium = medium;
        return (A)this;
    }

    @Override
    public Boolean hasMedium() {
        return this.medium != null;
    }

    @Override
    public A withNewMedium(String arg1) {
        return this.withMedium(new String(arg1));
    }

    @Override
    public A withNewMedium(StringBuilder arg1) {
        return this.withMedium(new String(arg1));
    }

    @Override
    public A withNewMedium(StringBuffer arg1) {
        return this.withMedium(new String(arg1));
    }

    @Override
    @Deprecated
    public Quantity getSizeLimit() {
        return this.sizeLimit != null ? this.sizeLimit.build() : null;
    }

    @Override
    public Quantity buildSizeLimit() {
        return this.sizeLimit != null ? this.sizeLimit.build() : null;
    }

    @Override
    public A withSizeLimit(Quantity sizeLimit) {
        this._visitables.get("sizeLimit").remove(this.sizeLimit);
        if (sizeLimit != null) {
            this.sizeLimit = new QuantityBuilder(sizeLimit);
            this._visitables.get("sizeLimit").add(this.sizeLimit);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSizeLimit() {
        return this.sizeLimit != null;
    }

    @Override
    public A withNewSizeLimit(String amount, String format) {
        return this.withSizeLimit(new Quantity(amount, format));
    }

    @Override
    public A withNewSizeLimit(String amount) {
        return this.withSizeLimit(new Quantity(amount));
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> withNewSizeLimit() {
        return new SizeLimitNestedImpl();
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> withNewSizeLimitLike(Quantity item) {
        return new SizeLimitNestedImpl(item);
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> editSizeLimit() {
        return this.withNewSizeLimitLike(this.getSizeLimit());
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> editOrNewSizeLimit() {
        return this.withNewSizeLimitLike(this.getSizeLimit() != null ? this.getSizeLimit() : new QuantityBuilder().build());
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> editOrNewSizeLimitLike(Quantity item) {
        return this.withNewSizeLimitLike(this.getSizeLimit() != null ? this.getSizeLimit() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmptyDirVolumeSourceFluentImpl that = (EmptyDirVolumeSourceFluentImpl)o;
        if (this.medium != null ? !this.medium.equals(that.medium) : that.medium != null) {
            return false;
        }
        return !(this.sizeLimit != null ? !this.sizeLimit.equals(that.sizeLimit) : that.sizeLimit != null);
    }

    public class SizeLimitNestedImpl<N>
    extends QuantityFluentImpl<EmptyDirVolumeSourceFluent.SizeLimitNested<N>>
    implements EmptyDirVolumeSourceFluent.SizeLimitNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        SizeLimitNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        SizeLimitNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)EmptyDirVolumeSourceFluentImpl.this.withSizeLimit(this.builder.build());
        }

        @Override
        public N endSizeLimit() {
            return this.and();
        }
    }
}

