/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.okta;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.okta.OktaAuth;
import org.jbpm.process.workitem.okta.model.OktaApplication;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="OktaGetApplications.wid", name="OktaGetApplications", displayName="OktaGetApplications", defaultHandler="mvel: new org.jbpm.process.workitem.okta.GetApplicationsWorkitemHandler(\"apiToken\")", documentation="okta-workitem/index.html", category="okta-workitem", icon="OktaGetApplications.png", parameters={@WidParameter(name="AppIds")}, results={@WidResult(name="Applications", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="okta-workitem", version="7.55.0.Final")}, serviceInfo=@WidService(category="Okta", description="Interact with Okta management API", keywords="okta,auth,application,get", action=@WidAction(title="Get applications from Okta"), authinfo=@WidAuth(required=true, params={"apiToken"}, paramsdescription={"Okta api token"}, referencesite="https://developer.okta.com/")))
public class GetApplicationsWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private Client oktaClient;
    private OktaAuth auth = new OktaAuth();
    private static final String RESULTS_VALUE = "Applications";

    public GetApplicationsWorkitemHandler() throws Exception {
        try {
            this.oktaClient = this.auth.authorize();
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public GetApplicationsWorkitemHandler(String apiToken) throws Exception {
        try {
            this.oktaClient = this.auth.authorize(apiToken);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public GetApplicationsWorkitemHandler(Client oktaClient) {
        this.oktaClient = oktaClient;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String appids = (String)workItem.getParameter("AppIds");
            ArrayList retAppList = new ArrayList();
            ApplicationList appList = this.oktaClient.listApplications();
            if (appids != null && appids.length() > 0) {
                List<String> appidsList = Arrays.asList(appids.split(","));
                appList.stream().filter(app -> appidsList.contains(app.getId())).forEach(app -> retAppList.add(new OktaApplication((Application)app)));
            } else {
                appList.stream().forEach(app -> retAppList.add(new OktaApplication((Application)app)));
            }
            HashMap results = new HashMap();
            results.put(RESULTS_VALUE, retAppList);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

