/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Iterator;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public final class ClearGraphCommand
extends AbstractGraphCommand {
    private final String rootUUID;

    public ClearGraphCommand(@MapsTo(value="rootUUID") String rootUUID) {
        this.rootUUID = rootUUID;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            Graph<?, Node> graph = this.getGraph(context);
            if (this.hasRootUUID()) {
                Iterator nodes = graph.nodes().iterator();
                if (null != nodes) {
                    nodes.forEachRemaining(node -> {
                        if (!node.getUUID().equals(this.rootUUID)) {
                            this.getMutableIndex(context).removeNode(node);
                            nodes.remove();
                        } else {
                            node.getOutEdges().stream().forEach(edge -> this.getMutableIndex(context).removeEdge((Edge)edge));
                            node.getOutEdges().clear();
                        }
                    });
                }
            } else {
                graph.clear();
                this.getMutableIndex(context).clear();
            }
        }
        return results;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        if (this.hasRootUUID()) {
            this.getNodeNotNull(context, this.rootUUID);
        }
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        throw new UnsupportedOperationException("Undo operation for Clear Graph Command is still not supported. ");
    }

    public String getRootUUID() {
        return this.rootUUID;
    }

    private boolean hasRootUUID() {
        return null != this.rootUUID && this.rootUUID.trim().length() > 0;
    }

    public String toString() {
        return "ClearGraphCommand [rootUUID=" + this.rootUUID + "]";
    }
}

