/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup.criteria;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.lookup.AbstractLookupManager;
import org.kie.workbench.common.stunner.core.lookup.LookupManager;

public abstract class AbstractCriteriaLookupManager<I, T, R extends LookupManager.LookupRequest>
extends AbstractLookupManager<I, T, R> {
    protected static final String CRITERIA_SEPARATOR = ";";
    protected static final String VALUE_SEPARATOR = "=";
    protected static final String COLLECTION_START_CHAR = "[";
    protected static final String COLLECTION_END_CHAR = "]";
    protected static final String COLLECTION_DELIMITER = ",";

    protected abstract boolean matches(String var1, String var2, I var3);

    protected boolean matches(String criteria, I item) {
        Map<String, String> criterias = AbstractCriteriaLookupManager.parseCriteria(criteria);
        if (null != criterias) {
            for (Map.Entry<String, String> entry : criterias.entrySet()) {
                if (this.matches(entry.getKey(), entry.getValue(), item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Map<String, String> parseCriteria(String criteria) {
        if (null != criteria && criteria.trim().length() > 0) {
            String[] criterias;
            HashMap<String, String> result = new HashMap<String, String>(criteria.length());
            for (String c : criterias = criteria.split(CRITERIA_SEPARATOR)) {
                String[] pair = AbstractCriteriaLookupManager.parseCriteriaPair(c);
                if (null == pair) continue;
                result.put(pair[0], pair[1]);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public static String[] parseCriteriaPair(String criteria) {
        if (null != criteria) {
            String[] s = criteria.split(VALUE_SEPARATOR);
            if (s.length == 0) {
                return null;
            }
            if (s.length != 2) {
                throw new IllegalArgumentException("Cannot parse lookup request criteria [pair='" + criteria + "']");
            }
            return new String[]{s[0].trim(), s[1]};
        }
        return null;
    }

    protected Collection<String> toCollection(String s) {
        if (s != null && !s.startsWith(COLLECTION_START_CHAR)) {
            return new HashSet<String>(0);
        }
        if (s != null && s.startsWith(COLLECTION_START_CHAR) && s.endsWith(COLLECTION_END_CHAR)) {
            String toParse = s.substring(1, s.length() - 1);
            String[] parsed = toParse.split(COLLECTION_DELIMITER);
            HashSet<String> result = new HashSet<String>(parsed.length);
            for (String p : parsed) {
                result.add(p.trim());
            }
            return result;
        }
        return new HashSet<String>(0);
    }

    protected static <T> boolean isIntersect(Collection<T> c1, T[] c2) {
        return AbstractCriteriaLookupManager.isIntersect(c1, Arrays.stream(c2).collect(Collectors.toSet()));
    }

    protected static <T> boolean isIntersect(Collection<T> c1, Collection<T> c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null) {
            return false;
        }
        for (T t : c1) {
            if (!c2.contains(t)) continue;
            return true;
        }
        return false;
    }
}

