/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks;

import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.UserTask;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.CatchEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class AssociationsTest
extends BPMNDiagramMarshallerBaseTest {
    private static final String BPMN_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/associationsAndAssignments.bpmn";
    private static final String TASK_ID = "_5E1F51EC-B398-4BF7-B32D-45FB6CE4731A";

    public AssociationsTest() {
        this.init();
    }

    @Test
    public void parseAssociations() throws Exception {
        Diagram<Graph, Metadata> d = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_FILE_PATH);
        Node node = d.getGraph().getNode(TASK_ID);
        org.kie.workbench.common.stunner.bpmn.definition.UserTask definition = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((View)node.getContent()).getDefinition();
        AssignmentsInfo assignmentsinfo = definition.getExecutionSet().getAssignmentsinfo();
        TestCase.assertEquals((String)"|Body:String,From:String,Subject:String,To:String||CUSTOM:String,CUSTOM2:String|[din]Body=HELLO,[din]myprocvar->From,[dout]CUSTOM->myprocvar", (String)assignmentsinfo.getValue());
    }

    @Test
    public void marshallUnassignedDeclaration() {
        String id = "PARENT";
        String decl = "||Foo:String||";
        StartEvent startEvent = Factories.bpmn2.createStartEvent();
        startEvent.setId(id);
        CatchEventPropertyWriter p = new CatchEventPropertyWriter((CatchEvent)startEvent, (VariableScope)new FlatVariableScope(), new HashSet());
        p.setAssignmentsInfo(new AssignmentsInfo(decl));
        TestCase.assertEquals((int)1, (int)p.getItemDefinitions().size());
        TestCase.assertEquals((String)Ids.dataOutputItem((String)id, (String)"Foo"), (String)((ItemDefinition)p.getItemDefinitions().get(0)).getId());
        TestCase.assertEquals((String)"String", (String)((ItemDefinition)p.getItemDefinitions().get(0)).getStructureRef());
        TestCase.assertEquals((int)1, (int)startEvent.getDataOutputs().size());
        TestCase.assertEquals((String)"Foo", (String)((DataOutput)startEvent.getDataOutputs().get(0)).getName());
        TestCase.assertEquals((int)0, (int)startEvent.getDataOutputAssociation().size());
    }

    @Test
    public void marshallAssociations() throws Exception {
        Diagram<Graph, Metadata> d = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_FILE_PATH);
        DefinitionsConverter definitionsConverter = new DefinitionsConverter(d.getGraph());
        Definitions definitions = definitionsConverter.toDefinitions();
        Process p = (Process)definitions.getRootElements().get(0);
        UserTask flowElement = (UserTask)p.getFlowElements().stream().filter(e -> e.getId().equals(TASK_ID)).findFirst().get();
        List associations = flowElement.getDataInputAssociations();
        TestCase.assertEquals((String)"myprocvar", (String)this.findVar(associations, "From"));
        TestCase.assertEquals((String)"<![CDATA[HELLO]]>", (String)this.findAssignment(associations, "Body"));
    }

    private String findVar(List<DataInputAssociation> associations, String varName) {
        return associations.stream().filter(a -> {
            DataInput in = (DataInput)a.getTargetRef();
            return in.getName().equals(varName);
        }).map(a -> {
            Property dataOutput = (Property)a.getSourceRef().get(0);
            return dataOutput.getName();
        }).findFirst().get();
    }

    private String findAssignment(List<DataInputAssociation> associations, String varName) {
        return associations.stream().filter(a -> {
            DataInput in = (DataInput)a.getTargetRef();
            return in.getName().equals(varName);
        }).map(a -> {
            Assignment assignment = (Assignment)a.getAssignment().get(0);
            FormalExpression expr = (FormalExpression)assignment.getFrom();
            return expr.getBody();
        }).findFirst().get();
    }
}

