/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.ExtendDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.ResolutionContext;
import org.infinispan.protostream.descriptors.namespace.FileNamespace;
import org.infinispan.protostream.descriptors.namespace.Namespace;
import org.infinispan.protostream.impl.Log;

public final class FileDescriptor {
    private static final Log log = Log.LogFactory.getLog(FileDescriptor.class);
    protected Configuration configuration;
    private final String name;
    private final String packageName;
    private final List<String> dependencies;
    private final List<String> publicDependencies;
    private final List<Option> options;
    private final List<Descriptor> messageTypes;
    private final List<EnumDescriptor> enumTypes;
    private final List<ExtendDescriptor> extendTypes;
    private final Map<String, ExtendDescriptor> extendDescriptors = new HashMap<String, ExtendDescriptor>();
    private final Map<String, FileDescriptor> dependants = new HashMap<String, FileDescriptor>();
    private FileNamespace fileNamespace;
    private Status status;
    private DescriptorParserException parsingException;

    private FileDescriptor(Builder builder) {
        this.name = builder.name;
        this.packageName = builder.packageName;
        this.dependencies = Collections.unmodifiableList(builder.dependencies);
        this.publicDependencies = Collections.unmodifiableList(builder.publicDependencies);
        this.options = Collections.unmodifiableList(builder.options);
        this.enumTypes = Collections.unmodifiableList(builder.enumTypes);
        this.messageTypes = Collections.unmodifiableList(builder.messageTypes);
        this.extendTypes = Collections.unmodifiableList(builder.extendDescriptors);
        this.parsingException = builder.parsingException;
        this.status = this.parsingException != null ? Status.PARSING_ERROR : Status.UNRESOLVED;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, FileDescriptor> getDependants() {
        return this.dependants;
    }

    public boolean isResolved() {
        return this.status.isResolved();
    }

    public void markUnresolved() {
        this.status = Status.UNRESOLVED;
    }

    void markError() {
        if (this.status != Status.PARSING_ERROR) {
            this.status = Status.ERROR;
        }
    }

    public void clearErrors() {
        if (this.status != Status.RESOLVED && this.status != Status.PARSING_ERROR) {
            this.markUnresolved();
            this.fileNamespace = null;
            this.extendDescriptors.clear();
            for (FileDescriptor fd : this.dependants.values()) {
                fd.clearErrors();
            }
            this.dependants.clear();
        }
    }

    public Namespace getExportedNamespace() {
        if (this.status != Status.RESOLVED) {
            throw new IllegalStateException("File " + this.name + " is not resolved yet");
        }
        return this.fileNamespace.getExportedNamespace();
    }

    public void resolveDependencies(ResolutionContext resolutionContext) throws DescriptorParserException {
        this.resolveDependencies(resolutionContext, new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDependencies(ResolutionContext resolutionContext, Set<String> processedFiles) throws DescriptorParserException {
        if (this.status == Status.PARSING_ERROR) {
            resolutionContext.handleError(this, this.parsingException);
            return;
        }
        if (this.status != Status.UNRESOLVED) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Resolving dependencies of %s", this.name);
        }
        try {
            List<FileDescriptor> pubDeps = this.resolveImports(this.publicDependencies, resolutionContext, processedFiles);
            List<FileDescriptor> deps = this.resolveImports(this.dependencies, resolutionContext, processedFiles);
            if (this.status.isError()) {
                return;
            }
            this.fileNamespace = new FileNamespace(this, pubDeps, deps);
            for (FileDescriptor fd : pubDeps) {
                fd.dependants.put(this.name, this);
            }
            for (FileDescriptor fd : deps) {
                fd.dependants.put(this.name, this);
            }
            for (Descriptor desc : this.messageTypes) {
                this.collectDescriptors(desc, resolutionContext);
            }
            for (EnumDescriptor enumDesc : this.enumTypes) {
                this.collectEnumDescriptors(enumDesc, resolutionContext);
            }
            for (ExtendDescriptor extendDescriptor : this.extendTypes) {
                this.collectExtensions(extendDescriptor);
            }
            for (Descriptor descriptor : this.messageTypes) {
                this.resolveFieldTypes(descriptor);
            }
            for (ExtendDescriptor extendDescriptor : this.extendTypes) {
                this.resolveExtension(extendDescriptor);
            }
            this.status = Status.RESOLVED;
            resolutionContext.flush();
            resolutionContext.handleSuccess(this);
        }
        catch (DescriptorParserException dpe) {
            resolutionContext.handleError(this, dpe);
        }
        catch (Exception e) {
            resolutionContext.handleError(this, new DescriptorParserException(e));
        }
        finally {
            if (this.status != Status.RESOLVED) {
                resolutionContext.clear();
            }
        }
    }

    private List<FileDescriptor> resolveImports(List<String> dependencies, ResolutionContext resolutionContext, Set<String> processedFiles) throws DescriptorParserException {
        ArrayList<FileDescriptor> fileDescriptors = new ArrayList<FileDescriptor>(dependencies.size());
        HashSet<String> uniqueDependencies = new HashSet<String>(dependencies.size());
        for (String dependency : dependencies) {
            if (!uniqueDependencies.add(dependency)) {
                resolutionContext.handleError(this, new DescriptorParserException("Duplicate import : " + dependency));
                continue;
            }
            FileDescriptor fd = resolutionContext.getFileDescriptorMap().get(dependency);
            if (fd == null) {
                resolutionContext.handleError(this, new DescriptorParserException("Import '" + dependency + "' not found"));
                continue;
            }
            if (fd.status == Status.UNRESOLVED) {
                if (!processedFiles.add(dependency)) {
                    resolutionContext.handleError(this, new DescriptorParserException("Cyclic import detected at " + this.name + ", import " + dependency));
                    continue;
                }
                fd.resolveDependencies(resolutionContext, processedFiles);
            }
            if (fd.status.isError()) {
                resolutionContext.handleError(this, new DescriptorParserException("File " + this.name + " imports a file (" + fd.getName() + ") that has errors"));
                continue;
            }
            fileDescriptors.add(fd);
        }
        return fileDescriptors;
    }

    private void collectDescriptors(Descriptor descriptor, ResolutionContext resolutionContext) {
        descriptor.setFileDescriptor(this);
        this.fileNamespace.put(descriptor.getFullName(), descriptor);
        resolutionContext.addGenericDescriptor(descriptor);
        for (Descriptor nested : descriptor.getNestedTypes()) {
            this.collectDescriptors(nested, resolutionContext);
        }
        for (EnumDescriptor enumDescriptor : descriptor.getEnumTypes()) {
            this.collectEnumDescriptors(enumDescriptor, resolutionContext);
        }
    }

    private void collectEnumDescriptors(EnumDescriptor enumDescriptor, ResolutionContext resolutionContext) {
        enumDescriptor.setFileDescriptor(this);
        this.fileNamespace.put(enumDescriptor.getFullName(), enumDescriptor);
        resolutionContext.addGenericDescriptor(enumDescriptor);
    }

    private void collectExtensions(ExtendDescriptor extendDescriptor) {
        extendDescriptor.setFileDescriptor(this);
        this.extendDescriptors.put(extendDescriptor.getFullName(), extendDescriptor);
    }

    private void resolveFieldTypes(Descriptor descriptor) {
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (fieldDescriptor.getType() != null) continue;
            GenericDescriptor res = this.searchType(fieldDescriptor.getTypeName(), descriptor);
            if (res instanceof EnumDescriptor) {
                fieldDescriptor.setEnumType((EnumDescriptor)res);
                continue;
            }
            if (res instanceof Descriptor) {
                fieldDescriptor.setMessageType((Descriptor)res);
                continue;
            }
            throw new DescriptorParserException("Field type " + fieldDescriptor.getTypeName() + " not found");
        }
        for (Descriptor nested : descriptor.getNestedTypes()) {
            this.resolveFieldTypes(nested);
        }
    }

    private void resolveExtension(ExtendDescriptor extendDescriptor) {
        GenericDescriptor res = this.searchType(extendDescriptor.getName(), null);
        if (res == null) {
            throw new DescriptorParserException("Extension error: type " + extendDescriptor.getName() + " not found");
        }
        if (res instanceof EnumDescriptor) {
            throw new DescriptorParserException("Enumerations cannot be extended: " + extendDescriptor.getFullName());
        }
        extendDescriptor.setExtendedMessage((Descriptor)res);
    }

    private String getScopedName(String name) {
        return this.packageName == null ? name : this.packageName.concat(".").concat(name);
    }

    private GenericDescriptor searchType(String name, Descriptor scope) {
        GenericDescriptor fullyQualified = this.fileNamespace.get(this.getScopedName(name));
        if (fullyQualified != null) {
            return fullyQualified;
        }
        GenericDescriptor relativeName = this.fileNamespace.get(name);
        if (relativeName != null) {
            return relativeName;
        }
        if (scope != null) {
            Descriptor containingType;
            String searchScope = scope.getFullName().concat(".").concat(name);
            GenericDescriptor o = this.fileNamespace.get(searchScope);
            if (o != null) {
                return o;
            }
            while ((containingType = scope.getContainingType()) != null) {
                GenericDescriptor res = this.searchType(name, containingType);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        return this.packageName;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String name) {
        for (Option o : this.options) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public List<EnumDescriptor> getEnumTypes() {
        return this.enumTypes;
    }

    public List<Descriptor> getMessageTypes() {
        return this.messageTypes;
    }

    public List<ExtendDescriptor> getExtensionsTypes() {
        return this.extendTypes;
    }

    public Map<String, GenericDescriptor> getTypes() {
        if (this.status != Status.RESOLVED) {
            throw new IllegalStateException("File " + this.name + " is not resolved yet");
        }
        return this.fileNamespace.getLocalNamespace().getTypes();
    }

    public String toString() {
        return "FileDescriptor{name='" + this.name + '\'' + ", packageName='" + this.packageName + '\'' + ", status=" + (Object)((Object)this.status) + '}';
    }

    public static final class Builder {
        private String name;
        private String packageName;
        private List<String> dependencies = Collections.emptyList();
        private List<String> publicDependencies = Collections.emptyList();
        private List<Option> options = Collections.emptyList();
        private List<EnumDescriptor> enumTypes = Collections.emptyList();
        private List<Descriptor> messageTypes = Collections.emptyList();
        private List<ExtendDescriptor> extendDescriptors = Collections.emptyList();
        private DescriptorParserException parsingException;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder withDependencies(List<String> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public Builder withPublicDependencies(List<String> publicDependencies) {
            this.publicDependencies = publicDependencies;
            return this;
        }

        public Builder withExtendDescriptors(List<ExtendDescriptor> extendDescriptors) {
            this.extendDescriptors = extendDescriptors;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withEnumTypes(List<EnumDescriptor> enumTypes) {
            this.enumTypes = enumTypes;
            return this;
        }

        public Builder withMessageTypes(List<Descriptor> messageTypes) {
            this.messageTypes = messageTypes;
            return this;
        }

        public Builder withParsingException(DescriptorParserException parsingException) {
            this.parsingException = parsingException;
            return this;
        }

        public FileDescriptor build() {
            return new FileDescriptor(this);
        }
    }

    private static enum Status {
        UNRESOLVED,
        RESOLVED,
        ERROR,
        PARSING_ERROR;


        boolean isResolved() {
            return this == RESOLVED;
        }

        boolean isError() {
            return this == ERROR || this == PARSING_ERROR;
        }
    }
}

