/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.kie.workbench.common.screens.library.api.RepositoryFileListUpdatedEvent;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.event.BatchIndexEvent;
import org.uberfire.ext.metadata.event.IndexEvent;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;

@ApplicationScoped
public class LibraryFileUpdateNotifier {
    private final WorkspaceProjectService workspaceProjectService;
    private final Event<RepositoryFileListUpdatedEvent> repositoryFileListUpdatedEvent;

    @Inject
    public LibraryFileUpdateNotifier(WorkspaceProjectService workspaceProjectService, Event<RepositoryFileListUpdatedEvent> repositoryFileListUpdatedEvent) {
        this.workspaceProjectService = workspaceProjectService;
        this.repositoryFileListUpdatedEvent = repositoryFileListUpdatedEvent;
    }

    public void onBatchIndexEvent(@Observes BatchIndexEvent event) {
        event.getIndexEvents().stream().flatMap(evt -> {
            switch (evt.getKind()) {
                case Deleted: {
                    return Stream.of(((IndexEvent.DeletedEvent)evt).getDeleted().getKey());
                }
                case NewlyIndexed: {
                    return Stream.of(((IndexEvent.NewlyIndexedEvent)evt).getKObject().getKey());
                }
                case Renamed: {
                    return Stream.of(((IndexEvent.RenamedEvent)evt).getTarget().getKey());
                }
            }
            return Stream.empty();
        }).map(pathStr -> {
            Path path = this.getPath((String)pathStr);
            WorkspaceProject project = this.workspaceProjectService.resolveProject(this.convertPath(path));
            String repositoryId = project.getRepository().getIdentifier();
            String branchName = path instanceof JGitPathImpl ? ((JGitPathImpl)path).getRefTree() : null;
            return new RepositoryFileListUpdatedEvent(repositoryId, branchName);
        }).distinct().forEach(arg_0 -> this.repositoryFileListUpdatedEvent.fire(arg_0));
    }

    Path getPath(String pathStr) {
        return org.uberfire.java.nio.file.Paths.get((String)pathStr, (String[])new String[0]);
    }

    org.uberfire.backend.vfs.Path convertPath(Path path) {
        return Paths.convert((Path)path);
    }
}

