/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.manager._private;

import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@MessageLogger(projectCode="WFSM")
public interface SecurityMessages {
    public static final SecurityMessages access = (SecurityMessages)Logger.getMessageLogger(SecurityMessages.class, (String)"org.wildfly.security.access");
    public static final SecurityMessages permission = (SecurityMessages)Logger.getMessageLogger(SecurityMessages.class, (String)"org.wildfly.security.permission");

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\", principals \"%s\")")
    public void accessCheckFailed(Permission var1, CodeSource var2, ClassLoader var3, String var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\")")
    public void accessCheckFailed(Permission var1, CodeSource var2, ClassLoader var3);

    @Message(id=1, value="Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\")")
    public AccessControlException accessControlException(@Param Permission var1, Permission var2, CodeSource var3, ClassLoader var4);

    @Message(id=2, value="Security manager may not be changed")
    public SecurityException secMgrChange();

    @Message(id=3, value="Unknown security context type")
    public SecurityException unknownContext();

    @Message(id=6, value="Invalid permission name '%s'")
    public IllegalArgumentException invalidName(String var1);

    @Message(id=7, value="Permission collection is read-only")
    public SecurityException readOnlyPermCollection();

    @Message(id=8, value="Invalid permission (expected an instance of %s, but got %s)")
    public IllegalArgumentException wrongPermType(Class<? extends Permission> var1, Permission var2);
}

