/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.backend.config;

import java.net.URI;
import javax.inject.Inject;
import org.kie.workbench.common.screens.archetype.mgmt.backend.config.ArchetypeConfigStorage;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.Archetype;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.spaces.SpacesAPI;
import org.uberfire.util.URIUtil;

public class ArchetypeConfigStorageImpl
implements ArchetypeConfigStorage {
    public static final String ARCHETYPES_SPACE_NAME = ".archetypes";
    private static final String FILE_FORMAT = "json";
    private final ObjectStorage objectStorage;

    @Inject
    public ArchetypeConfigStorageImpl(ObjectStorage objectStorage) {
        this.objectStorage = objectStorage;
    }

    @Override
    public void setup() {
        this.objectStorage.init(this.getRootURI());
    }

    @Override
    public Archetype loadArchetype(String alias) {
        return (Archetype)this.objectStorage.read(this.buildArchetypePath(alias));
    }

    @Override
    public void saveArchetype(Archetype archetype) {
        this.objectStorage.write(this.buildArchetypePath(archetype.getAlias()), (Object)archetype);
    }

    @Override
    public void deleteArchetype(String alias) {
        this.objectStorage.delete(this.buildArchetypePath(alias));
    }

    private URI getRootURI() {
        return URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)ARCHETYPES_SPACE_NAME));
    }

    private String buildArchetypePath(String alias) {
        return String.format("/config/%s.%s", this.encode(alias), FILE_FORMAT);
    }

    private String encode(String text) {
        return URIUtil.encodeQueryString((String)text);
    }
}

