/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git.hooks.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import org.apache.commons.io.FilenameUtils;
import org.guvnor.structure.backend.LocaleContext;
import org.jboss.errai.bus.server.api.RpcContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class MessageReader {
    private static final Logger LOG = LoggerFactory.getLogger(MessageReader.class);
    private Path bundlePath;
    private String bundleName;
    private Supplier<Locale> localeSupplier;

    public MessageReader() {
        this(() -> RpcContext.getServletRequest().getLocale());
    }

    MessageReader(Supplier<Locale> localeSupplier) {
        this.localeSupplier = localeSupplier;
    }

    public void init(String bundleParam) {
        if (bundleParam != null) {
            Path fullPath = Paths.get(bundleParam, new String[0]);
            File bundleFile = fullPath.toFile();
            if (bundleFile.exists()) {
                this.bundlePath = bundleFile.toPath().getParent();
                this.bundleName = FilenameUtils.getBaseName((String)bundleFile.getName());
            } else {
                LOG.error("Invalid bundle '" + bundleParam + "': file doesn't exist");
            }
        }
    }

    public Optional<String> resolveMessage(int exitCode) {
        String result = null;
        if (this.bundlePath != null && this.bundleName != null) {
            try {
                URL[] urls = new URL[]{this.bundlePath.toUri().toURL()};
                URLClassLoader bundleClassLoader = new URLClassLoader(urls);
                ResourceBundle bundle = ResourceBundle.getBundle(this.bundleName, this.getLocale(), bundleClassLoader);
                result = bundle.getString(String.valueOf(exitCode));
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find key for code '" + exitCode + "' bundle '" + this.bundlePath.resolve(this.bundleName).toString() + "'");
            }
            catch (MalformedURLException e) {
                LOG.warn("Cannot load bundle '" + this.bundlePath.resolve(this.bundleName).toString() + "': ", (Throwable)e);
            }
        }
        return Optional.ofNullable(result);
    }

    private Locale getLocale() {
        try {
            return this.localeSupplier.get();
        }
        catch (Exception e) {
            LOG.warn("Locale info not available in RpcContext.");
            return LocaleContext.get();
        }
    }
}

