/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model.typedescriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class FactModelTree {
    private String factName;
    private String fullPackage;
    private String typeName;
    private boolean isSimple = false;
    private Map<String, PropertyTypeName> simpleProperties;
    private Map<String, List<String>> genericTypesMap;
    private Map<String, String> expandableProperties = new HashMap<String, String>();
    private Type type;
    private String importPrefix;

    public static FactModelTree ofDMO(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, String typeName) {
        return new FactModelTree(factName, fullPackage, simpleProperties, genericTypesMap, Type.UNDEFINED, typeName, null);
    }

    public static FactModelTree ofSimpleDMO(String factName, String fullPackage, String simplePropertyFullClass, String typeName) {
        HashMap<String, PropertyTypeName> simpleProperties = new HashMap<String, PropertyTypeName>();
        simpleProperties.put("value", new PropertyTypeName(simplePropertyFullClass));
        FactModelTree toReturn = new FactModelTree(factName, fullPackage, simpleProperties, Collections.emptyMap(), Type.UNDEFINED, typeName, null);
        toReturn.setSimple(true);
        return toReturn;
    }

    public static FactModelTree ofDMN(String factName, String importPrefix, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, String typeName, Type type) {
        return new FactModelTree(factName, "", simpleProperties, genericTypesMap, type, typeName, importPrefix);
    }

    public static FactModelTree ofSimpleDMN(String factName, String importPrefix, String simplePropertyType, Map<String, List<String>> genericTypeInfoMap, String typeName, Type type) {
        HashMap<String, PropertyTypeName> simpleProperties = new HashMap<String, PropertyTypeName>();
        simpleProperties.put("value", new PropertyTypeName(simplePropertyType));
        FactModelTree toReturn = new FactModelTree(factName, "", simpleProperties, genericTypeInfoMap, type, typeName, importPrefix);
        toReturn.setSimple(true);
        return toReturn;
    }

    public FactModelTree() {
    }

    public FactModelTree(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap) {
        this(factName, fullPackage, simpleProperties, genericTypesMap, Type.UNDEFINED);
    }

    public FactModelTree(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, String typeName) {
        this(factName, fullPackage, simpleProperties, genericTypesMap, Type.UNDEFINED, typeName, "");
    }

    public FactModelTree(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, Type type) {
        this(factName, fullPackage, simpleProperties, genericTypesMap, type, null, "");
    }

    private FactModelTree(String factName, String fullPackage, Map<String, PropertyTypeName> simpleProperties, Map<String, List<String>> genericTypesMap, Type type, String typeName, String importedPrefix) {
        this.factName = factName;
        this.fullPackage = fullPackage;
        this.simpleProperties = simpleProperties;
        this.genericTypesMap = genericTypesMap;
        this.type = type;
        this.typeName = typeName;
        this.importPrefix = importedPrefix;
    }

    public String getFactName() {
        return this.factName;
    }

    public String getFullPackage() {
        return this.fullPackage;
    }

    public Map<String, PropertyTypeName> getSimpleProperties() {
        return this.simpleProperties;
    }

    public Map<String, String> getExpandableProperties() {
        return this.expandableProperties;
    }

    public Map<String, List<String>> getGenericTypesMap() {
        return this.genericTypesMap;
    }

    public void addSimpleProperty(String propertyName, PropertyTypeName propertyTypeName) {
        this.simpleProperties.put(propertyName, propertyTypeName);
    }

    public void addExpandableProperty(String propertyName, String propertyType) {
        this.expandableProperties.put(propertyName, propertyType);
    }

    public List<String> getGenericTypeInfo(String propertyName) {
        return this.genericTypesMap.getOrDefault(propertyName, new ArrayList());
    }

    public void removeSimpleProperty(String propertyName) {
        this.simpleProperties.remove(propertyName);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean simple) {
        this.isSimple = simple;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName != null ? this.typeName : this.factName;
    }

    public String getFullTypeName() {
        return this.fullPackage == null || this.fullPackage.isEmpty() ? this.getTypeName() : this.fullPackage + "." + this.getTypeName();
    }

    public String getImportPrefix() {
        return this.importPrefix;
    }

    public FactModelTree cloneFactModelTree() {
        HashMap<String, PropertyTypeName> clonedSimpleProperties = new HashMap<String, PropertyTypeName>(this.simpleProperties);
        Map<String, List<String>> clonedGenericTypesMap = this.genericTypesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            ArrayList toReturn = new ArrayList();
            toReturn.addAll((Collection)e.getValue());
            return toReturn;
        }));
        FactModelTree toReturn = new FactModelTree(this.factName, this.fullPackage, clonedSimpleProperties, clonedGenericTypesMap, this.type, this.typeName, this.importPrefix);
        toReturn.expandableProperties = new HashMap<String, String>(this.expandableProperties);
        toReturn.isSimple = this.isSimple;
        return toReturn;
    }

    public String toString() {
        return "FactModelTree{factName='" + this.factName + '\'' + "typeName='" + this.typeName + '\'' + ", simpleProperties=" + this.simpleProperties + ", expandableProperties=" + this.expandableProperties + '}';
    }

    public static class PropertyTypeName {
        private String typeName;
        private Optional<String> baseTypeName;

        public PropertyTypeName() {
            this.typeName = null;
            this.baseTypeName = Optional.empty();
        }

        public PropertyTypeName(String typeName) {
            this.typeName = typeName;
            this.baseTypeName = Optional.empty();
        }

        public PropertyTypeName(String typeName, String baseTypeName) {
            this.typeName = typeName;
            this.baseTypeName = Optional.ofNullable(baseTypeName);
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Optional<String> getBaseTypeName() {
            return this.baseTypeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public void setBaseTypeName(String baseTypeName) {
            this.baseTypeName = Optional.ofNullable(baseTypeName);
        }

        public String getPropertyTypeNameToVisualize() {
            return this.baseTypeName.orElse(this.typeName.replace('$', '.'));
        }
    }

    public static enum Type {
        INPUT,
        DECISION,
        UNDEFINED;

    }
}

