/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports;

import org.kie.soup.commons.validation.PortablePreconditions;

public final class ImageDataUriContent {
    private final String uri;
    private final String mimeType;
    private final String data;

    public static ImageDataUriContent create(String uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        String[] uriParts = uri.split(",");
        return new ImageDataUriContent(uri, ImageDataUriContent.parseMimeType(uriParts[0]), uriParts[1]);
    }

    private ImageDataUriContent(String uri, String mimeType, String data) {
        this.uri = uri;
        this.mimeType = mimeType;
        this.data = data;
    }

    public String getUri() {
        return this.uri;
    }

    public String getData() {
        return this.data;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    private static String parseMimeType(String uriDataType) {
        String mimeType = uriDataType.split(":")[1];
        int encIndex = mimeType.indexOf(";");
        return encIndex > -1 ? mimeType.substring(0, encIndex) : mimeType;
    }
}

