/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.template.mustache;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.ScriptInjector;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.ext.editor.commons.client.template.mustache.Mustache;
import org.uberfire.ext.editor.commons.client.template.mustache.MustacheSource;
import org.uberfire.ext.editor.commons.template.mustache.MustacheTemplateRenderer;

@ApplicationScoped
public class ClientMustacheTemplateRenderer
implements MustacheTemplateRenderer<Object> {
    private final Function<String, ScriptInjector.FromString> scriptInjector;
    private final Supplier<MustacheSource> sourceSupplier;

    @Inject
    public ClientMustacheTemplateRenderer() {
        this(() -> (MustacheSource)GWT.create(MustacheSource.class), ScriptInjector::fromString);
    }

    protected ClientMustacheTemplateRenderer(Supplier<MustacheSource> sourceSupplier, Function<String, ScriptInjector.FromString> scriptInjector) {
        this.sourceSupplier = sourceSupplier;
        this.scriptInjector = scriptInjector;
    }

    @PostConstruct
    protected void init() {
        MustacheSource source = this.sourceSupplier.get();
        this.inject(source.mustache().getText());
    }

    private void inject(String raw) {
        ScriptInjector.FromString js = this.scriptInjector.apply(raw);
        js.setWindow(ScriptInjector.TOP_WINDOW).setRemoveTag(false).inject();
    }

    public String render(String template, Object data) {
        return Mustache.to_html(template, data);
    }
}

