/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.BackendFormRenderingContextImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshallerRegistry;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.ContextModelConstraintsExtractor;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.MapModelRenderingContext;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
public class BackendFormRenderingContextManagerImpl
implements BackendFormRenderingContextManager {
    private static final Logger logger = LoggerFactory.getLogger(BackendFormRenderingContextManagerImpl.class);
    protected Map<Long, BackendFormRenderingContextImpl> contexts = new HashMap<Long, BackendFormRenderingContextImpl>();
    protected FieldValueMarshallerRegistry registry;
    protected ContextModelConstraintsExtractor constraintsExtractor;

    @Inject
    public BackendFormRenderingContextManagerImpl(FieldValueMarshallerRegistry registry, ContextModelConstraintsExtractor constraintsExtractor) {
        this.registry = registry;
        this.constraintsExtractor = constraintsExtractor;
    }

    public BackendFormRenderingContext registerContext(FormDefinition rootForm, Map<String, Object> formData, ClassLoader classLoader, FormDefinition ... nestedForms) {
        return this.registerContext(rootForm, formData, classLoader, new HashMap<String, String>(), nestedForms);
    }

    public BackendFormRenderingContext registerContext(FormDefinition rootForm, Map<String, Object> formData, ClassLoader classLoader, Map<String, String> params, FormDefinition ... nestedForms) {
        MapModelRenderingContext clientRenderingContext = new MapModelRenderingContext(String.valueOf(System.currentTimeMillis()));
        clientRenderingContext.setRootForm(rootForm);
        Arrays.stream(nestedForms).forEach(form -> clientRenderingContext.getAvailableForms().put(form.getId(), form));
        BackendFormRenderingContextImpl context = new BackendFormRenderingContextImpl(System.currentTimeMillis(), clientRenderingContext, formData, classLoader, params);
        HashMap clientFormData = new HashMap();
        rootForm.getFields().stream().filter(fieldDefinition -> !StringUtils.isEmpty((CharSequence)fieldDefinition.getBinding())).forEach(fieldDefinition -> {
            Object value = formData.get(fieldDefinition.getBinding());
            FieldValueMarshaller marshaller = this.registry.getMarshaller((FieldDefinition)fieldDefinition);
            if (marshaller != null) {
                marshaller.init(value, fieldDefinition, rootForm, context);
                context.getRootFormMarshallers().put(fieldDefinition.getBinding(), marshaller);
                value = marshaller.toFlatValue();
            }
            clientFormData.put(fieldDefinition.getBinding(), value);
        });
        this.constraintsExtractor.readModelConstraints(clientRenderingContext, classLoader);
        clientRenderingContext.setModel(clientFormData);
        this.contexts.put(context.getTimestamp(), context);
        return context;
    }

    public BackendFormRenderingContext updateContextData(long timestamp, Map<String, Object> formValues) {
        BackendFormRenderingContextImpl context = this.contexts.get(timestamp);
        if (context == null) {
            throw new IllegalArgumentException("Unable to find context with id '" + timestamp + "'");
        }
        FormDefinition rootForm = context.getRenderingContext().getRootForm();
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        rootForm.getFields().stream().filter(fieldDefinition -> !StringUtils.isEmpty((CharSequence)fieldDefinition.getBinding())).forEach(fieldDefinition -> {
            Object value = formValues.get(fieldDefinition.getBinding());
            FieldValueMarshaller marshaller = context.getRootFormMarshallers().get(fieldDefinition.getBinding());
            if (marshaller != null) {
                value = marshaller.toRawValue(value);
            }
            contextData.put(fieldDefinition.getBinding(), value);
        });
        context.setFormData(contextData);
        return context;
    }

    public BackendFormRenderingContext getContext(Long timestamp) {
        return this.contexts.get(timestamp);
    }

    public boolean removeContext(Long timestamp) {
        return this.contexts.remove(timestamp) != null;
    }
}

