/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.models;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshallerRegistry;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.JavaFormModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(ModelMarshaller.class);
    private FieldValueMarshallerRegistry registry;
    private Object model;
    private FormDefinition formDefinition;
    private BackendFormRenderingContext context;
    private String type;
    private Map<String, FieldValueMarshaller> marshallers = new HashMap<String, FieldValueMarshaller>();

    public ModelMarshaller(FieldValueMarshallerRegistry registry, Object model, FormDefinition formDefinition, BackendFormRenderingContext context) {
        this.registry = registry;
        this.model = model;
        this.formDefinition = formDefinition;
        this.context = context;
        if (!(formDefinition.getModel() instanceof JavaFormModel)) {
            throw new IllegalStateException("Cannot initialize a ModelMarshaller for model type " + formDefinition.getModel().getClass());
        }
        this.type = ((JavaFormModel)formDefinition.getModel()).getType();
        this.iterateFormFields(this::registerMarshaller);
    }

    private void registerMarshaller(FieldDefinition field) {
        FieldValueMarshaller marshaller = this.registry.getMarshaller(field);
        if (marshaller != null) {
            marshaller.init(this.readValue(field.getBinding()), field, this.formDefinition, this.context);
            this.marshallers.put(field.getBinding(), marshaller);
        }
    }

    private Object readValue(String property) {
        if (this.model != null) {
            try {
                if (PropertyUtils.getPropertyDescriptor((Object)this.model, (String)property) != null) {
                    return PropertyUtils.getProperty((Object)this.model, (String)property);
                }
            }
            catch (Exception e) {
                logger.warn("Error getting property '{}' from object '{}'", (Object)property, this.model);
                logger.warn("Caused by:", (Throwable)e);
            }
        }
        return null;
    }

    public Map<String, Object> toFlatValue() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.model != null) {
            this.iterateFormFields(fieldDefinition -> {
                String binding = fieldDefinition.getBinding();
                FieldValueMarshaller marshaller = this.marshallers.get(binding);
                if (marshaller != null) {
                    result.put(binding, marshaller.toFlatValue());
                } else {
                    result.put(binding, this.readValue(binding));
                }
            });
        }
        return result;
    }

    public Object toRawValue(Map<String, Object> values) {
        if (this.model == null) {
            this.model = this.newInstance();
        }
        this.iterateFormFields(fieldDefinition -> {
            String binding = fieldDefinition.getBinding();
            FieldValueMarshaller marshaller = this.marshallers.get(binding);
            Object flatValue = values.get(binding);
            if (marshaller != null) {
                this.writeValue(binding, marshaller.toRawValue(flatValue));
            } else {
                this.writeValue(binding, flatValue);
            }
        });
        return this.model;
    }

    private void writeValue(String property, Object value) {
        try {
            if (PropertyUtils.getPropertyDescriptor((Object)this.model, (String)property) != null) {
                BeanUtils.setProperty((Object)this.model, (String)property, (Object)value);
            }
        }
        catch (Exception e) {
            logger.warn("Error modifying object '{}': cannot set value '{}' to property '{}'", new Object[]{this.model, value, property});
            logger.warn("Caused by:", (Throwable)e);
        }
    }

    private Object newInstance() {
        Class<?> clazz = null;
        try {
            clazz = this.context.getClassLoader().loadClass(this.type);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName(this.type);
            }
            catch (ClassNotFoundException e1) {
                logger.warn("Unable to find class '{}' on classLoader", (Object)this.type);
            }
        }
        if (clazz != null) {
            try {
                return ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Unable to create instance for class {}: ", (Object)this.type);
            }
        }
        throw new IllegalStateException("Unable to create instance for class " + this.type);
    }

    private void iterateFormFields(Consumer<FieldDefinition> consumer) {
        this.formDefinition.getFields().stream().filter(fieldDefinition -> !StringUtils.isEmpty((CharSequence)fieldDefinition.getBinding())).forEach(consumer);
    }

    public Object getModel() {
        return this.model;
    }
}

