/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.screens.datamodeller.backend.server.validation.PersistenceDescriptorValidationMessages;

public class PropertyValidator {
    public List<ValidationMessage> validate(String name, String value) {
        return this.validate(name, value, -1);
    }

    public List<ValidationMessage> validate(String name, String value, int propertyIndex) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (name == null || name.trim().isEmpty()) {
            if (propertyIndex >= 0) {
                messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.INDEXED_PROPERTY_NAME_EMPTY_ID, MessageFormat.format("Property #{0} must have a non empty name", Integer.toString(propertyIndex)), Integer.toString(propertyIndex)));
            } else {
                messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.PROPERTY_NAME_EMPTY_ID, "Property name should have a non empty String value", new String[0]));
            }
        }
        if (value == null || value.trim().isEmpty()) {
            messages.add(PersistenceDescriptorValidationMessages.newWarningMessage(PersistenceDescriptorValidationMessages.PROPERTY_VALUE_EMPTY_ID, MessageFormat.format("Property \"{0}\" has an empty value assigned", name), name));
        }
        return messages;
    }
}

