/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;

public class DynamicSizedSchedulerImpl
extends ScheduledThreadPoolExecutor
implements DynamicSizedSchedulerInterface {
    private static final AtomicInteger POOL_ID = new AtomicInteger();

    public DynamicSizedSchedulerImpl(int corePoolSize) {
        super(corePoolSize, new ThreadFactory(){
            private final int thisPoolId = DynamicSizedSchedulerImpl.access$000().incrementAndGet();
            private final ThreadFactory parentFactory = Executors.defaultThreadFactory();
            private final AtomicInteger threadId = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = this.parentFactory.newThread(runnable);
                result.setName("mariaDb-reconnection-" + this.thisPoolId + "-" + this.threadId.incrementAndGet());
                return result;
            }
        });
    }

    @Override
    public void setPoolSize(int newSize) {
        super.setCorePoolSize(newSize);
    }

    static /* synthetic */ AtomicInteger access$000() {
        return POOL_ID;
    }
}

