/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDefineFunctionFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDerivedFieldFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLTransformationDictionaryFactory {
    public static final String TRANSFORMATION_DICTIONARY = "transformationDictionary";
    static final String KIE_PMML_TRANSFORMATION_DICTIONARY_TEMPLATE_JAVA = "KiePMMLTransformationDictionaryTemplate.tmpl";
    static final String KIE_PMML_TRANSFORMATION_DICTIONARY_TEMPLATE = "KiePMMLTransformationDictionaryTemplate";
    static final String GETKIEPMMLTRANSFORMATIONDICTIONARY = "getKiePMMLTransformationDictionary";
    static final ClassOrInterfaceDeclaration TRANSFORMATION_DICTIONARY_TEMPLATE;

    private KiePMMLTransformationDictionaryFactory() {
    }

    static BlockStmt getKiePMMLTransformationDictionaryVariableDeclaration(TransformationDictionary transformationDictionary) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)TRANSFORMATION_DICTIONARY_TEMPLATE.getMethodsByName(GETKIEPMMLTRANSFORMATIONDICTIONARY).get(0)).clone();
        BlockStmt transformationDictionaryBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(transformationDictionaryBody, TRANSFORMATION_DICTIONARY).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", TRANSFORMATION_DICTIONARY, transformationDictionaryBody)));
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", TRANSFORMATION_DICTIONARY, methodDeclaration)))).asMethodCallExpr();
        BlockStmt toReturn = new BlockStmt();
        if (transformationDictionary.hasDefineFunctions()) {
            NodeList<Expression> defineFunctions = KiePMMLTransformationDictionaryFactory.addDefineFunctions(toReturn, transformationDictionary.getDefineFunctions());
            CommonCodegenUtils.getChainedMethodCallExprFrom("withDefineFunctions", initializer).setArguments(defineFunctions);
        }
        if (transformationDictionary.hasDerivedFields()) {
            NodeList<Expression> derivedFields = KiePMMLTransformationDictionaryFactory.addDerivedField(toReturn, transformationDictionary.getDerivedFields());
            CommonCodegenUtils.getChainedMethodCallExprFrom("withDerivedFields", initializer).setArguments(derivedFields);
        }
        transformationDictionaryBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static NodeList<Expression> addDefineFunctions(BlockStmt body, List<DefineFunction> defineFunctions) {
        NodeList arguments = new NodeList();
        for (DefineFunction defineFunction : defineFunctions) {
            arguments.add((Node)new NameExpr(defineFunction.getName()));
            BlockStmt toAdd = KiePMMLDefineFunctionFactory.getDefineFunctionVariableDeclaration(defineFunction);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)body).addStatement(arg_0));
        }
        return KiePMMLTransformationDictionaryFactory.getArraysAsListInvocation((NodeList<Expression>)arguments);
    }

    static NodeList<Expression> addDerivedField(BlockStmt body, List<DerivedField> derivedFields) {
        NodeList arguments = new NodeList();
        int counter = 0;
        for (DerivedField derivedField : derivedFields) {
            String nestedVariableName = String.format("transformationDictionaryDerivedField_%s", counter);
            arguments.add((Node)new NameExpr(nestedVariableName));
            BlockStmt toAdd = KiePMMLDerivedFieldFactory.getDerivedFieldVariableDeclaration(nestedVariableName, derivedField);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)body).addStatement(arg_0));
            ++counter;
        }
        return KiePMMLTransformationDictionaryFactory.getArraysAsListInvocation((NodeList<Expression>)arguments);
    }

    private static NodeList<Expression> getArraysAsListInvocation(NodeList<Expression> arguments) {
        MethodCallExpr methodCallExpr = new MethodCallExpr();
        methodCallExpr.setScope((Expression)new NameExpr(Arrays.class.getSimpleName()));
        methodCallExpr.setName("asList");
        methodCallExpr.setArguments(arguments);
        return NodeList.nodeList((Node[])new Expression[]{methodCallExpr});
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_TRANSFORMATION_DICTIONARY_TEMPLATE_JAVA);
        TRANSFORMATION_DICTIONARY_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_TRANSFORMATION_DICTIONARY_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLTransformationDictionaryTemplate"));
        ((MethodDeclaration)TRANSFORMATION_DICTIONARY_TEMPLATE.getMethodsByName(GETKIEPMMLTRANSFORMATIONDICTIONARY).get(0)).clone();
    }
}

