/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.backend.service;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.openshift.access.OpenShiftTemplate;
import org.guvnor.ala.ui.openshift.model.DefaultSettings;
import org.guvnor.ala.ui.openshift.model.TemplateDescriptorModel;
import org.guvnor.ala.ui.openshift.model.TemplateParam;
import org.guvnor.ala.ui.openshift.service.OpenShiftClientService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@ApplicationScoped
public class OpenShiftClientServiceImpl
implements OpenShiftClientService {
    private static final Logger logger = LoggerFactory.getLogger(OpenShiftClientServiceImpl.class);
    private static DefaultSettings defaultSettingsInstance;
    private static final String PROJECT_NAME_EXPRESSION = "(([a-z]+)|([0-9]+)|([\\-]+))+";

    public DefaultSettings getDefaultSettings() {
        if (defaultSettingsInstance == null) {
            defaultSettingsInstance = new DefaultSettings();
            defaultSettingsInstance.setValue("org.kie.provisioning.openshift.defaultTemplate", System.getProperty("org.kie.provisioning.openshift.defaultTemplate"));
            defaultSettingsInstance.setValue("org.kie.provisioning.openshift.defaultImageStreams", System.getProperty("org.kie.provisioning.openshift.defaultImageStreams"));
            defaultSettingsInstance.setValue("org.kie.provisioning.openshift.defaultSecrets", System.getProperty("org.kie.provisioning.openshift.defaultSecrets"));
            logger.debug("OpenShift default settings were set to");
            logger.debug("org.kie.provisioning.openshift.defaultTemplate = " + defaultSettingsInstance.getValue("org.kie.provisioning.openshift.defaultTemplate"));
            logger.debug("org.kie.provisioning.openshift.defaultImageStreams = " + defaultSettingsInstance.getValue("org.kie.provisioning.openshift.defaultImageStreams"));
            logger.debug("org.kie.provisioning.openshift.defaultSecrets = " + defaultSettingsInstance.getValue("org.kie.provisioning.openshift.defaultSecrets"));
        }
        return defaultSettingsInstance;
    }

    public TemplateDescriptorModel getTemplateModel(String url) {
        PortablePreconditions.checkNotNull((String)"url", (Object)url);
        OpenShiftTemplate template = new OpenShiftTemplate(url);
        List<TemplateParam> params = this.buildTemplateParams(template);
        TemplateDescriptorModel descriptorModel = new TemplateDescriptorModel(params);
        return descriptorModel;
    }

    public boolean isValidProjectName(String projectName) {
        return projectName != null && !projectName.startsWith("-") && !projectName.endsWith("-") && Pattern.compile(PROJECT_NAME_EXPRESSION).matcher(projectName).matches();
    }

    private List<TemplateParam> buildTemplateParams(OpenShiftTemplate template) {
        return template.getParameters().stream().map(param -> new TemplateParam(param.getName(), param.getDisplayName(), param.getDescription(), param.isRequired(), param.getValue())).collect(Collectors.toList());
    }
}

