/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model.segmentation;

import java.util.List;
import java.util.Objects;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;

public class KiePMMLSegment
extends AbstractKiePMMLComponent {
    private final KiePMMLPredicate kiePMMLPredicate;
    private final KiePMMLModel model;
    protected double weight = 1.0;

    protected KiePMMLSegment(String name, List<KiePMMLExtension> extensions, KiePMMLPredicate kiePMMLPredicate, KiePMMLModel model) {
        super(name, extensions);
        this.kiePMMLPredicate = kiePMMLPredicate;
        this.model = model;
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, KiePMMLPredicate kiePMMLPredicate, KiePMMLModel model) {
        return new Builder(name, extensions, kiePMMLPredicate, model);
    }

    public double getWeight() {
        return this.weight;
    }

    public KiePMMLPredicate getKiePMMLPredicate() {
        return this.kiePMMLPredicate;
    }

    public KiePMMLModel getModel() {
        return this.model;
    }

    public String toString() {
        return "KiePMMLSegment{kiePMMLPredicate=" + this.kiePMMLPredicate + ", model=" + this.model + ", weight=" + this.weight + ", name='" + this.name + '\'' + ", extensions=" + this.extensions + ", id='" + this.id + '\'' + ", parentId='" + this.parentId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KiePMMLSegment that = (KiePMMLSegment)((Object)o);
        return Double.compare(that.weight, this.weight) == 0 && Objects.equals(this.kiePMMLPredicate, that.kiePMMLPredicate) && Objects.equals(this.model, that.model);
    }

    public int hashCode() {
        return Objects.hash(this.kiePMMLPredicate, this.model, this.weight);
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLSegment> {
        private Builder(String name, List<KiePMMLExtension> extensions, KiePMMLPredicate kiePMMLPredicate, KiePMMLModel model) {
            super("Segmentation-", () -> new KiePMMLSegment(name, extensions, kiePMMLPredicate, model));
            kiePMMLPredicate.setParentId(((KiePMMLSegment)this.toBuild).id);
            model.setParentId(((KiePMMLSegment)this.toBuild).id);
        }

        public Builder withWeight(double weight) {
            ((KiePMMLSegment)this.toBuild).weight = weight;
            return this;
        }
    }
}

