/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.mail;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.gmail.Gmail;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;

public class GoogleMailAuth {
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static HttpTransport HTTP_TRANSPORT;
    private static final List<String> SCOPES;

    public Gmail getGmailService(String appName, String clientSecretJSON) {
        try {
            HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            Credential credential = this.authorize(clientSecretJSON);
            return new Gmail.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(appName).build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Credential authorize(String clientSecretJSON) throws Exception {
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new StringReader(clientSecretJSON));
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, SCOPES).setAccessType("offline").build();
        Credential credential = new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)new LocalServerReceiver()).authorize("user");
        return credential;
    }

    static {
        SCOPES = Arrays.asList("https://www.googleapis.com/auth/gmail.labels", "https://www.googleapis.com/auth/gmail.compose", "https://www.googleapis.com/auth/gmail.send");
    }
}

