/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.screens.dtablexls.backend.server.ExtendedDecisionTableXLSService;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSContent;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSConversionService;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.source.SourceGenerationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class DecisionTableXLSServiceImpl
extends KieService<DecisionTableXLSContent>
implements DecisionTableXLSService,
ExtendedDecisionTableXLSService {
    private static final Logger log = LoggerFactory.getLogger(DecisionTableXLSServiceImpl.class);
    private CopyService copyService;
    private DeleteService deleteService;
    private RenameService renameService;
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    private DecisionTableXLSConversionService conversionService;
    private GenericValidator genericValidator;
    private CommentedOptionFactory commentedOptionFactory;
    private AuthenticationService authenticationService;

    public DecisionTableXLSServiceImpl() {
    }

    @Inject
    public DecisionTableXLSServiceImpl(@Named(value="ioStrategy") IOService ioService, CopyService copyService, DeleteService deleteService, RenameService renameService, Event<ResourceOpenedEvent> resourceOpenedEvent, DecisionTableXLSConversionService conversionService, GenericValidator genericValidator, CommentedOptionFactory commentedOptionFactory, AuthenticationService authenticationService) {
        this.ioService = ioService;
        this.copyService = copyService;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.resourceOpenedEvent = resourceOpenedEvent;
        this.conversionService = conversionService;
        this.genericValidator = genericValidator;
        this.commentedOptionFactory = commentedOptionFactory;
        this.authenticationService = authenticationService;
    }

    protected DecisionTableXLSContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        DecisionTableXLSContent content = new DecisionTableXLSContent();
        content.setOverview(overview);
        return content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream load(org.uberfire.backend.vfs.Path path, String sessionId) {
        try (InputStream inputStream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[]{StandardOpenOption.READ});){
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.getSessionInfo(sessionId)));
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path resource, InputStream content, String sessionId, String comment) {
        return this.writeToFile(resource, content, sessionId, comment, true);
    }

    @Override
    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, InputStream content, String sessionId, String comment) {
        return this.writeToFile(resource, content, sessionId, comment, false);
    }

    private org.uberfire.backend.vfs.Path writeToFile(org.uberfire.backend.vfs.Path resource, InputStream content, String sessionId, String comment, boolean create) {
        SessionInfo sessionInfo = this.getSessionInfo(sessionId);
        log.info("USER: {} {} asset [{}]", new Object[]{sessionInfo.getIdentity().getIdentifier(), create ? "CREATING" : "UPDATING", resource.getFileName()});
        try {
            Path nioPath;
            Throwable throwable;
            block43: {
                File tempFile = File.createTempFile("testxls", null);
                throwable = null;
                try (FileOutputStream tempFOS = new FileOutputStream(tempFile);){
                    IOUtils.copy((InputStream)content, (OutputStream)tempFOS);
                    tempFOS.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                this.validate(tempFile);
                nioPath = Paths.convert((org.uberfire.backend.vfs.Path)resource);
                this.ioService.startBatch(nioPath.getFileSystem());
                try (FileInputStream tempFIS = new FileInputStream(tempFile);){
                    if (create) {
                        this.ioService.write(nioPath, IOUtils.toByteArray((InputStream)tempFIS), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment, sessionInfo.getIdentity(), sessionInfo)});
                        break block43;
                    }
                    try (OutputStream outputStream = this.ioService.newOutputStream(nioPath, new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment, sessionInfo.getIdentity(), sessionInfo)});){
                        IOUtils.copy((InputStream)tempFIS, (OutputStream)outputStream);
                        outputStream.flush();
                    }
                }
            }
            throwable = Paths.convert((Path)nioPath);
            return throwable;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    void validate(File tempFile) {
        try {
            Workbook workbook = WorkbookFactory.create((File)tempFile);
            Throwable throwable = null;
            if (workbook != null) {
                if (throwable != null) {
                    try {
                        workbook.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    workbook.close();
                }
            }
        }
        catch (IOException e) {
            throw new DecisionTableParseException("DecisionTableParseException: Failed to open Excel stream, please check that the content is xls97 format.", (Throwable)e);
        }
        catch (Exception e) {
            throw new DecisionTableParseException("DecisionTableParseException: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSource(org.uberfire.backend.vfs.Path path) {
        try (InputStream inputStream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[]{StandardOpenOption.READ});){
            SpreadsheetCompiler compiler = new SpreadsheetCompiler();
            String string = compiler.compile(inputStream, InputType.XLS);
            return string;
        }
        catch (Exception e) {
            throw new SourceGenerationFailedException(e.getMessage());
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ConversionResult convert(org.uberfire.backend.vfs.Path path) {
        try {
            return this.conversionService.convert(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, org.uberfire.backend.vfs.Path resource) {
        try {
            return this.genericValidator.validate(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private SessionInfo getSessionInfo(String sessionId) {
        return new SafeSessionInfo((SessionInfo)new SessionInfoImpl(sessionId, this.authenticationService.getUser()));
    }
}

