/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.client.modal;

import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.archetype.mgmt.client.modal.AddArchetypeModalPresenter;
import org.uberfire.client.views.pfly.widgets.ValidationState;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Templated
public class AddArchetypeModalView
implements AddArchetypeModalPresenter.View,
IsElement {
    private static final String EMPTY = "";
    private AddArchetypeModalPresenter presenter;
    private BaseModal modal;
    private Button addButton;
    @Inject
    private TranslationService ts;
    @Inject
    private BusyIndicatorView busyIndicatorView;
    @Inject
    @DataField(value="content")
    private HTMLDivElement content;
    @Inject
    @DataField(value="error")
    private HTMLDivElement error;
    @Inject
    @Named(value="span")
    @DataField(value="error-message")
    private HTMLElement errorMessage;
    @Inject
    @DataField(value="archetype-group-id-group")
    private HTMLDivElement archetypeGroupIdGroup;
    @Inject
    @DataField(value="archetype-group-id-help-block")
    private HelpBlock archetypeGroupIdHelpBlock;
    @Inject
    @DataField(value="archetype-group-id")
    private HTMLInputElement archetypeGroupId;
    @Inject
    @DataField(value="archetype-artifact-id-group")
    private HTMLDivElement archetypeArtifactIdGroup;
    @Inject
    @DataField(value="archetype-artifact-id-help-block")
    private HelpBlock archetypeArtifactIdHelpBlock;
    @Inject
    @DataField(value="archetype-artifact-id")
    private HTMLInputElement archetypeArtifactId;
    @Inject
    @DataField(value="archetype-version-group")
    private HTMLDivElement archetypeVersionGroup;
    @Inject
    @DataField(value="archetype-version-help-block")
    private HelpBlock archetypeVersionHelpBlock;
    @Inject
    @DataField(value="archetype-version")
    private HTMLInputElement archetypeVersion;

    public void init(AddArchetypeModalPresenter presenter) {
        this.presenter = presenter;
        this.setupModal();
    }

    @Override
    public void show() {
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void showGeneralError(String errorMessage) {
        this.errorMessage.innerHTML = errorMessage;
        this.error.hidden = false;
    }

    @Override
    public void showArchetypeGroupIdError(String errorMessage) {
        this.showFieldError(this.archetypeGroupIdGroup, this.archetypeGroupIdHelpBlock, errorMessage);
    }

    @Override
    public void showArchetypeArtifactIdError(String errorMessage) {
        this.showFieldError(this.archetypeArtifactIdGroup, this.archetypeArtifactIdHelpBlock, errorMessage);
    }

    @Override
    public void showArchetypeVersionError(String errorMessage) {
        this.showFieldError(this.archetypeVersionGroup, this.archetypeVersionHelpBlock, errorMessage);
    }

    private void showFieldError(HTMLDivElement group, HelpBlock helpBlock, String errorMessage) {
        group.classList.add(new String[]{ValidationState.ERROR.getCssName()});
        helpBlock.setText(errorMessage);
    }

    @Override
    public void clearErrors() {
        this.clearFieldError(this.archetypeGroupIdGroup, this.archetypeGroupIdHelpBlock);
        this.clearFieldError(this.archetypeArtifactIdGroup, this.archetypeArtifactIdHelpBlock);
        this.clearFieldError(this.archetypeVersionGroup, this.archetypeVersionHelpBlock);
        this.error.hidden = true;
    }

    private void clearFieldError(HTMLDivElement group, HelpBlock helpBlock) {
        group.classList.remove(new String[]{ValidationState.ERROR.getCssName()});
        helpBlock.clearError();
    }

    @Override
    public String getArchetypeGroupId() {
        return this.archetypeGroupId.value;
    }

    @Override
    public String getArchetypeArtifactId() {
        return this.archetypeArtifactId.value;
    }

    @Override
    public String getArchetypeVersion() {
        return this.archetypeVersion.value;
    }

    @Override
    public void resetAll() {
        this.archetypeGroupId.value = EMPTY;
        this.archetypeArtifactId.value = EMPTY;
        this.archetypeVersion.value = EMPTY;
        this.clearErrors();
    }

    @Override
    public void enableAddButton(boolean isEnabled) {
        if (this.addButton != null) {
            this.addButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void enableFields(boolean isEnabled) {
        this.archetypeGroupId.disabled = !isEnabled;
        this.archetypeArtifactId.disabled = !isEnabled;
        this.archetypeVersion.disabled = !isEnabled;
    }

    private void setupModal() {
        this.modal = new CommonModalBuilder().addHeader(this.ts.format("ArchetypeManagement.AddArchetype", new Object[0])).addBody((HTMLElement)this.content).addFooter(this.createFooter()).build();
    }

    private ModalFooter createFooter() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.add((Widget)this.createCancelButton());
        footer.add((Widget)this.createAddButton());
        return footer;
    }

    private Button createAddButton() {
        this.addButton = this.createButton(this.ts.format("ArchetypeManagement.Add", new Object[0]), () -> this.presenter.add(), ButtonType.PRIMARY);
        return this.addButton;
    }

    private Button createCancelButton() {
        return this.createButton(this.ts.format("ArchetypeManagement.Cancel", new Object[0]), () -> this.presenter.cancel(), ButtonType.DEFAULT);
    }

    private Button createButton(String text, Command command, ButtonType type) {
        Button button = new Button(text, event -> command.execute());
        button.setType(type);
        return button;
    }
}

