/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSource;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata;
import org.kie.workbench.common.screens.datasource.management.metadata.TableMetadata;
import org.kie.workbench.common.screens.datasource.management.service.DatabaseMetadataService;
import org.kie.workbench.common.screens.datasource.management.util.DatabaseMetadataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@ApplicationScoped
public class DatabaseMetadataServiceImpl
implements DatabaseMetadataService {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMetadataServiceImpl.class);
    private DataSourceRuntimeManager dataSourceRuntimeManager;

    public DatabaseMetadataServiceImpl() {
    }

    @Inject
    public DatabaseMetadataServiceImpl(DataSourceRuntimeManager dataSourceRuntimeManager) {
        this.dataSourceRuntimeManager = dataSourceRuntimeManager;
    }

    public DatabaseMetadata getMetadata(String dataSourceUuid, boolean includeCatalogs, boolean includeSchemas) {
        PortablePreconditions.checkNotNull((String)"dataSourceUuid", (Object)dataSourceUuid);
        try {
            DataSource dataSource = this.dataSourceRuntimeManager.lookupDataSource(dataSourceUuid);
            return DatabaseMetadataUtil.getMetadata(dataSource.getConnection(), includeCatalogs, includeSchemas);
        }
        catch (Exception e) {
            logger.error("It was not possible to get database metadata for data source: " + dataSourceUuid, (Throwable)e);
            throw new GenericPortableException("It was not possible to get database metadata for data source: " + dataSourceUuid + ": " + e.getMessage(), e);
        }
    }

    public List<TableMetadata> findTables(String dataSourceUuid, String schema, DatabaseMetadata.TableType ... types) {
        return this.findTables(dataSourceUuid, schema, "%", types);
    }

    public List<TableMetadata> findTables(String dataSourceUuid, String schema, String tableNamePattern, DatabaseMetadata.TableType ... types) {
        PortablePreconditions.checkNotNull((String)"dataSourceUuid", (Object)dataSourceUuid);
        PortablePreconditions.checkNotNull((String)"types", (Object)types);
        try {
            DataSource dataSource = this.dataSourceRuntimeManager.lookupDataSource(dataSourceUuid);
            return DatabaseMetadataUtil.findTables(dataSource.getConnection(), schema, tableNamePattern, types);
        }
        catch (Exception e) {
            logger.error("It was not possible to get database metadata for data source: " + dataSourceUuid, (Throwable)e);
            throw new GenericPortableException("It was not possible to get database metadata for data source: " + dataSourceUuid + ": " + e.getMessage(), e);
        }
    }
}

