/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.locator;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.impl.locator.LatestContainerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLocatorProvider {
    private static final Logger logger = LoggerFactory.getLogger(ContainerLocatorProvider.class);
    private static final ServiceLoader<ContainerLocator> locators = ServiceLoader.load(ContainerLocator.class);
    private static ContainerLocatorProvider INSTANCE = new ContainerLocatorProvider();
    private Map<String, ContainerLocator> foundLocators = new HashMap<String, ContainerLocator>();
    private String locatorName = System.getProperty("org.kie.server.container.locator", LatestContainerLocator.class.getSimpleName());

    private ContainerLocatorProvider() {
        locators.forEach(l -> {
            this.foundLocators.put(l.getClass().getSimpleName(), (ContainerLocator)l);
            logger.info("Discovered '{}' container locator and registered under '{}'", l, (Object)l.getClass().getSimpleName());
        });
        this.foundLocators.put(LatestContainerLocator.class.getSimpleName(), LatestContainerLocator.get());
    }

    public ContainerLocator getLocator() {
        ContainerLocator containerLocator = this.foundLocators.get(this.locatorName);
        if (containerLocator == null) {
            throw new IllegalStateException("No container locator found under name " + this.locatorName);
        }
        return containerLocator;
    }

    public static ContainerLocatorProvider get() {
        return INSTANCE;
    }
}

