/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessageDecorator;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.kie.workbench.common.stunner.core.validation.Violation;

public class Match<In, Out> {
    private final Class<?> outputType;
    private final LinkedList<Case<?>> cases = new LinkedList();
    private final LinkedList<Case<?>> strictCases = new LinkedList();
    private Function<In, Out> orElse;
    private Out defaultValue;
    private Optional<MarshallingMessageDecorator<In>> inputDecorator = Optional.empty();
    private Optional<MarshallingMessageDecorator<Out>> outputDecorator = Optional.empty();
    private MarshallingRequest.Mode mode = MarshallingRequest.Mode.AUTO;

    public Match(Class<?> outputType) {
        this.outputType = outputType;
    }

    public static <In, Out> Match<In, Out> of(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>(outputType);
    }

    public static <In, Out> Match<In, Node<? extends View<? extends Out>, ?>> ofNode(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>(outputType);
    }

    public static <In, Out> Match<Node<? extends View<? extends In>, ?>, Out> fromNode(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>(outputType);
    }

    public static <In, Out> Match<In, Edge<? extends View<? extends Out>, ?>> ofEdge(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>(outputType);
    }

    private static <T, U> Function<T, Result<U>> reportMissing(Class<?> expectedClass) {
        return t -> Result.failure("Not yet implemented: " + Optional.ofNullable(t).map(o -> o.getClass().getCanonicalName()).orElse("null -- expected " + expectedClass.getCanonicalName()), new MarshallingMessage[0]);
    }

    private <T> Function<T, Result<Out>> ignored(Class<?> expectedClass) {
        return t -> Result.ignored("Ignored: " + Optional.ofNullable(t).map(o -> o.getClass().getCanonicalName()).orElse("null -- expected " + expectedClass.getCanonicalName()), this.defaultValue, MarshallingMessage.builder().message("Ignored " + t).build());
    }

    private <T> Function<T, Result<Out>> ignored(Class<?> expectedClass, Out outValue) {
        return t -> Result.ignored("Ignored: " + Optional.ofNullable(t).map(o -> o.getClass().getCanonicalName()).orElse("null -- expected " + expectedClass.getCanonicalName()), outValue, MarshallingMessage.builder().message("Ignored " + t).build());
    }

    public <Sub> Match<In, Out> when(Class<Sub> type, Function<Sub, Out> then) {
        Function<Object, Result> thenWrapped = sub -> Result.of(then.apply(sub), new MarshallingMessage[0]);
        return this.when_(type, thenWrapped);
    }

    private <Sub> Match<In, Out> when_(Class<Sub> type, Function<Sub, Result<Out>> then) {
        this.cases.add(new Case(type, then));
        return this;
    }

    public <Sub> Match<In, Out> whenExactly(Class<Sub> type, Function<Sub, Out> then) {
        Function<Object, Result> thenWrapped = sub -> Result.of(then.apply(sub), new MarshallingMessage[0]);
        return this.whenExactly_(type, thenWrapped);
    }

    private <Sub> Match<In, Out> whenExactly_(Class<Sub> type, Function<Sub, Result<Out>> then) {
        this.strictCases.add(new StrictCase<Sub>(type, then));
        return this;
    }

    public <Sub> Match<In, Out> missing(Class<Sub> type) {
        return this.when_(type, Match.reportMissing(type));
    }

    public <Sub> Match<In, Out> ignore(Class<Sub> type) {
        return this.when_(type, this.ignored(type));
    }

    public <Sub> Match<In, Out> ignore(Class<Sub> type, Out outValue) {
        return this.when_(type, this.ignored(type, outValue));
    }

    public Match<In, Out> orElse(Function<In, Out> then) {
        this.orElse = then;
        return this;
    }

    public Match<In, Out> inputDecorator(MarshallingMessageDecorator<In> decorator) {
        this.inputDecorator = Optional.ofNullable(decorator);
        return this;
    }

    public Match<In, Out> outputDecorator(MarshallingMessageDecorator<Out> decorator) {
        this.outputDecorator = Optional.ofNullable(decorator);
        return this;
    }

    public Match<In, Out> defaultValue(Out value) {
        this.defaultValue = value;
        return this;
    }

    public <Sub> Match<In, Out> mode(MarshallingRequest.Mode mode) {
        this.mode = mode;
        return this;
    }

    private Result<Out> apply(In value, List<Case<?>> cases, Supplier<Result<Out>> fallback) {
        return cases.stream().map(c -> c.match(value)).filter(Result::isSuccess).findFirst().orElseGet(fallback);
    }

    public Result<Out> apply(In value) {
        return this.apply(value, this.strictCases, () -> this.apply(value, this.cases, () -> this.applyFallback(value)));
    }

    private Result<Out> applyFallback(In value) {
        if (MarshallingRequest.Mode.ERROR.equals((Object)this.mode)) {
            return this.getFailure(value);
        }
        if (this.orElse == null || MarshallingRequest.Mode.IGNORE.equals((Object)this.mode)) {
            return Stream.concat(this.cases.stream(), this.strictCases.stream()).map(c -> c.match(value)).filter(Result::isIgnored).map(r -> {
                if (r.value() instanceof Result) {
                    ((Result)r.value()).setMessages(this.getIgnoreMessage(value));
                }
                return r;
            }).findFirst().orElseGet(() -> Result.failure(value == null ? "Null value" : value.getClass().getName(), this.defaultValue, this.getIgnoreMessage(value)));
        }
        Out result = this.orElse.apply(value);
        return Result.of(result, MarshallingMessage.builder().message("Converted element: " + value + "to: " + result).messageKey("MarshallingMessage.convertedElement").messageArguments(new String[]{this.getValueName(value, this.inputDecorator), this.getValueType(value, this.inputDecorator), this.getValueType(result, this.outputDecorator)}).type(Violation.Type.WARNING).build());
    }

    private MarshallingMessage getIgnoreMessage(In value) {
        return MarshallingMessage.builder().message("Ignored element " + value).messageKey("MarshallingMessage.ignoredElement").messageArguments(new String[]{this.getValueName(value, this.inputDecorator), this.getValueType(value, this.inputDecorator)}).type(Violation.Type.WARNING).build();
    }

    private Result<Out> getFailure(Object value) {
        return Result.failure(value.getClass().getName(), this.defaultValue, MarshallingMessage.builder().type(Violation.Type.ERROR).message("Failure there is no match for element " + value).messageKey("MarshallingMessage.elementFailure").messageArguments(new String[]{String.valueOf(value)}).build());
    }

    private <T> String getValueType(T value, Optional<MarshallingMessageDecorator<T>> decorator) {
        return decorator.map(d -> d.getType(value)).orElseGet(() -> Optional.ofNullable(value).map(Object::getClass).map(Class::getSimpleName).orElse(""));
    }

    private <T> String getValueName(T value, Optional<MarshallingMessageDecorator<T>> decorator) {
        return decorator.map(d -> d.getName(value)).orElseGet(() -> String.valueOf(value));
    }

    private class StrictCase<T>
    extends Case<T> {
        public StrictCase(Class<T> when, Function<T, Result<Out>> then) {
            super(when, then);
        }

        @Override
        public Result<Out> match(Object value) {
            return Objects.equals(this.when, value.getClass()) ? (Result)this.then.apply(value) : Match.this.getFailure(value);
        }
    }

    private class Case<T> {
        public final Class<T> when;
        public final Function<T, Result<Out>> then;

        private Case(Class<T> when, Function<T, Result<Out>> then) {
            this.when = when;
            this.then = then;
        }

        public Result<Out> match(Object value) {
            return this.when.isAssignableFrom(value.getClass()) ? this.then.apply(value) : Match.this.getFailure(value);
        }
    }
}

