/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class AssociationList {
    public static final String REGEX_DELIMITER = ",\\[";
    public static final String RANDOM_DELIMITER = UUID.randomUUID().toString();
    public static final String REPLACE_DELIMITER_AVOID_CONFLICTS = RANDOM_DELIMITER + ",[";
    public static final String REPLACED_DELIMITER = RANDOM_DELIMITER + ",";
    private final List<AssociationDeclaration> inputs;
    private final List<AssociationDeclaration> outputs;

    public AssociationList(List<AssociationDeclaration> inputs, List<AssociationDeclaration> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public AssociationList(List<AssociationDeclaration> all) {
        this.inputs = new ArrayList<AssociationDeclaration>();
        this.outputs = new ArrayList<AssociationDeclaration>();
        for (AssociationDeclaration associationDeclaration : all) {
            if (associationDeclaration.getDirection() == AssociationDeclaration.Direction.Input) {
                this.inputs.add(associationDeclaration);
                continue;
            }
            this.outputs.add(associationDeclaration);
        }
    }

    public AssociationList() {
        this.inputs = new ArrayList<AssociationDeclaration>();
        this.outputs = new ArrayList<AssociationDeclaration>();
    }

    public static AssociationList fromString(String encoded) {
        return Optional.ofNullable(encoded).filter(StringUtils::nonEmpty).map(s -> new AssociationList(Arrays.stream(s.replaceAll(REGEX_DELIMITER, REPLACE_DELIMITER_AVOID_CONFLICTS).split(REPLACED_DELIMITER)).map(AssociationDeclaration::fromString).collect(Collectors.toList()))).orElse(new AssociationList());
    }

    public List<AssociationDeclaration> getInputs() {
        return this.inputs;
    }

    public AssociationDeclaration lookupInput(String id) {
        return this.inputs.stream().filter(in -> in.getTarget().equals(id)).findFirst().orElse(null);
    }

    public List<AssociationDeclaration> lookupOutputs(String id) {
        return this.outputs.stream().filter(in -> in.getSource().equals(id)).collect(Collectors.toList());
    }

    public List<AssociationDeclaration> getOutputs() {
        return this.outputs;
    }

    public String toString() {
        return Stream.concat(this.inputs.stream(), this.outputs.stream()).map(AssociationDeclaration::toString).collect(Collectors.joining(","));
    }
}

