/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;

class CaseFileVariableReader {
    CaseFileVariableReader() {
    }

    static String getCaseFileVariables(List<Property> properties) {
        return properties.stream().filter(CaseFileVariableReader::isCaseFileVariable).map(CaseFileVariableReader::toCaseFileVariableString).collect(Collectors.joining(","));
    }

    private static String toCaseFileVariableString(Property p) {
        String variableName = CaseFileVariableReader.getCaseFileVariableName(p);
        String caseFileVariableName = variableName.substring("caseFile_".length());
        return Optional.ofNullable(p.getItemSubjectRef()).map(ItemDefinition::getStructureRef).map(type -> caseFileVariableName + ":" + type).orElse(caseFileVariableName);
    }

    private static String getCaseFileVariableName(Property p) {
        String name = p.getName();
        return name == null ? p.getId() : name;
    }

    public static boolean isCaseFileVariable(Property p) {
        String name = CaseFileVariableReader.getCaseFileVariableName(p);
        return name.startsWith("caseFile_");
    }
}

