/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.longrest;

import org.jbpm.process.longrest.util.Json;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.UnresolveablePropertyException;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessVariableResolverFactory
extends BaseVariableResolverFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProcessVariableResolverFactory.class);
    private final WorkflowProcessInstance processInstance;

    public ProcessVariableResolverFactory(WorkflowProcessInstance processInstance) {
        this.processInstance = processInstance;
        logger.debug("Created new ProcessVariableResolverFactory for processInstance {}.", (Object)processInstance.getId());
    }

    public VariableResolver createVariable(String name, Object value) {
        throw new ScriptRuntimeException("Cannot assign variables.");
    }

    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        throw new ScriptRuntimeException("Cannot assign variables.");
    }

    public boolean isTarget(String name) {
        return false;
    }

    public boolean isResolveable(String name) {
        logger.trace("Is variable {} resolvable in the processInstance {}.", (Object)name, (Object)this.processInstance.getId());
        Object processInstanceVariable = null;
        try {
            processInstanceVariable = this.processInstance.getVariable(name);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (processInstanceVariable != null) {
            logger.trace("Variable {} is resolvable in the processInstance {}.", (Object)name, (Object)this.processInstance.getId());
            return true;
        }
        if (this.nextFactory != null) {
            logger.trace("Variable {} is NOT resolvable in the processInstance {}, searching in the next factory.", (Object)name, (Object)this.processInstance.getId());
            return this.nextFactory.isResolveable(name);
        }
        logger.trace("Variable {} is NOT resolvable in the processInstance {}.", (Object)name, (Object)this.processInstance.getId());
        return false;
    }

    public VariableResolver getVariableResolver(String name) {
        logger.trace("Getting resolver for {} in the processInstance {}.", (Object)name, (Object)this.processInstance.getId());
        Object processInstanceVariable = null;
        try {
            processInstanceVariable = this.processInstance.getVariable(name);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (processInstanceVariable != null) {
            logger.trace("Returning SimpleValueResolver for {} in the processInstance {}.", (Object)name, (Object)this.processInstance.getId());
            return new SimpleValueResolver(Json.escape(processInstanceVariable));
        }
        if (this.nextFactory != null) {
            logger.trace("Looking-up for next variable resolver for {}.", (Object)name);
            return this.nextFactory.getVariableResolver(name);
        }
        throw new UnresolveablePropertyException("Unable to resolve variable '" + name + "'");
    }
}

