/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.validation.asset.DefaultGenericKieValidator;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorBuildService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.workbench.screens.solver.backend.server.XStreamSolutionImporter;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;

public class SolverValidator {
    private static final long SMOKE_TEST_MILLISECONDS_SPENT_LIMIT = 3000L;
    private static final Set<String> SMOKE_TEST_SUPPORTED_PROJECTS = new HashSet<String>();
    private KieModuleService moduleService;
    private BuildInfoService buildInfoService;
    private ValidatorBuildService validatorBuildService;

    public SolverValidator() {
    }

    @Inject
    public SolverValidator(KieModuleService moduleService, BuildInfoService buildInfoService, ValidatorBuildService validatorBuildService) {
        this.moduleService = moduleService;
        this.buildInfoService = buildInfoService;
        this.validatorBuildService = validatorBuildService;
    }

    public List<ValidationMessage> validate(Path resourcePath, String content) {
        return this.validate(resourcePath, content, false);
    }

    public List<ValidationMessage> validateAndRun(Path resourcePath, String content) {
        return this.validate(resourcePath, content, true);
    }

    private List<ValidationMessage> validate(Path resourcePath, String content, boolean runSolver) {
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(resourcePath);
        List validationMessages = new SolverValidatorImpl(this.validatorBuildService).validate(resourcePath, content);
        if (validationMessages.isEmpty()) {
            return this.buildSolver(resourcePath, kieModule, runSolver);
        }
        return validationMessages;
    }

    private List<ValidationMessage> buildSolver(Path resourcePath, KieModule kieModule, boolean runSolver) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        ValidationMessage validationMessage = this.createSolverFactory(resourcePath, kieModule, runSolver);
        if (validationMessage != null) {
            validationMessages.add(validationMessage);
        }
        return validationMessages;
    }

    private ValidationMessage createSolverFactory(Path resourcePath, KieModule kieWorkbenchModule, boolean runSolver) {
        InternalKieModule kieModule = (InternalKieModule)this.buildInfoService.getBuildInfo((Module)kieWorkbenchModule).getKieModuleIgnoringErrors();
        KieModuleKieProject kieProject = new KieModuleKieProject(kieModule, null);
        KieContainerImpl kieContainer = new KieContainerImpl((KieProject)kieProject, KieServices.Factory.get().getRepository());
        try {
            String solverConfigResource = this.getSolverConfigResource(resourcePath, kieWorkbenchModule);
            SolverFactory solverFactory = SolverFactory.createFromKieContainerXmlResource((KieContainer)kieContainer, (String)solverConfigResource);
            if (runSolver) {
                String projectName = this.resolveProjectName(resourcePath);
                if (!SMOKE_TEST_SUPPORTED_PROJECTS.contains(projectName)) {
                    throw new IllegalStateException("Running a smoke test for project (" + projectName + ") is not supported.");
                }
                solverFactory.getSolverConfig().getTerminationConfig().shortenTimeMillisSpentLimit(3000L);
                if (solverFactory.getSolverConfig().getScoreDirectorFactoryConfig().getKsessionName() == null) {
                    solverFactory.getSolverConfig().getScoreDirectorFactoryConfig().setKsessionName(kieProject.getDefaultKieSession().getName());
                }
                Solver solver = solverFactory.buildSolver();
                XStreamSolutionImporter solutionImporter = new XStreamSolutionImporter(kieContainer.getClassLoader());
                Object solution = solutionImporter.read(this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/workbench/screens/solver/backend/server/solution/" + projectName + ".xml"));
                solver.solve(solution);
            } else {
                solverFactory.buildSolver();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.make(e, resourcePath);
        }
        return null;
    }

    private String resolveProjectName(Path resourcePath) {
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(resourcePath);
        if (kieModule == null) {
            throw new IllegalStateException("Failed to resolve KieModule (" + kieModule + ").");
        }
        return kieModule.getModuleName();
    }

    private String getSolverConfigResource(Path resourcePath, KieModule kieWorkbenchModule) {
        return Paths.removePrefix((Path)resourcePath, (Path)kieWorkbenchModule.getRootPath()).substring("src/main/resources/".length());
    }

    private ValidationMessage make(Exception e, Path resourcePath) {
        ValidationMessage message = new ValidationMessage();
        message.setId(0L);
        message.setLevel(Level.ERROR);
        message.setPath(resourcePath);
        message.setText(e.getMessage());
        return message;
    }

    static {
        SMOKE_TEST_SUPPORTED_PROJECTS.add("optacloud");
    }

    private static class SolverValidatorImpl
    extends DefaultGenericKieValidator {
        SolverValidatorImpl(ValidatorBuildService validatorBuildService) {
            super(validatorBuildService);
        }

        protected Predicate<ValidationMessage> fromValidatedPath(Path path) {
            return message -> true;
        }
    }
}

