/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.screens.workbench.backend;

import io.swagger.jaxrs.config.BeanConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.kie.workbench.common.screens.server.management.utils.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerAPIScanner
implements ServletContextListener {
    private static final Boolean SWAGGER_DISABLED = Boolean.parseBoolean(System.getProperty("org.kie.workbench.swagger.disabled", "false"));
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerAPIScanner.class);

    public void contextInitialized(ServletContextEvent sce) {
        if (SWAGGER_DISABLED.booleanValue()) {
            return;
        }
        LOGGER.info("Starting Swagger API discovery");
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setBasePath(sce.getServletContext().getContextPath() + "/rest");
        if (ControllerUtils.useEmbeddedController()) {
            beanConfig.setResourcePackage("org.kie.server.controller.rest");
        }
        beanConfig.setVersion("7.0");
        beanConfig.setTitle("Business Central API");
        beanConfig.setPrettyPrint(true);
        beanConfig.setScan();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

