/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNGraphFactory;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNGraphFactoryImpl;
import org.kie.workbench.common.stunner.bpmn.project.backend.factory.CaseGraphFactoryImpl;
import org.kie.workbench.common.stunner.bpmn.service.ProjectType;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;

@Dependent
public class BPMNDelegateGraphFactory
implements BPMNGraphFactory {
    private final BPMNGraphFactoryImpl bpmnGraphFactory;
    private final CaseGraphFactoryImpl caseGraphFactory;
    private final GraphFactoryDelegation graphFactoryDelegation;

    @Inject
    public BPMNDelegateGraphFactory(BPMNGraphFactoryImpl bpmnGraphFactory, CaseGraphFactoryImpl caseGraphFactory) {
        this.bpmnGraphFactory = bpmnGraphFactory;
        this.caseGraphFactory = caseGraphFactory;
        this.graphFactoryDelegation = new GraphFactoryDelegation();
    }

    public boolean isDelegateFactory() {
        return true;
    }

    public void setDiagramType(Class<? extends BPMNDiagram> diagramType) {
        this.bpmnGraphFactory.setDiagramType(diagramType);
        this.caseGraphFactory.setDiagramType(diagramType);
    }

    public Class<? extends ElementFactory> getFactoryType() {
        return BPMNGraphFactory.class;
    }

    public Graph<DefinitionSet, Node> build(String uuid, String definition, Metadata metadata) {
        Optional<ProjectType> projectType = Objects.nonNull(metadata) && metadata instanceof ProjectMetadata ? Optional.ofNullable(((ProjectMetadata)metadata).getProjectType()).map(ProjectType::valueOf) : Optional.empty();
        return (Graph)this.graphFactoryDelegation.get(projectType).build(uuid, (Object)definition, metadata);
    }

    public Graph<DefinitionSet, Node> build(String uuid, String definition) {
        return this.build(uuid, definition, null);
    }

    public boolean accepts(String source) {
        return this.bpmnGraphFactory.accepts(source) && this.caseGraphFactory.accepts(source);
    }

    private class GraphFactoryDelegation {
        Map<ProjectType, BPMNGraphFactory> factoryMap;

        GraphFactoryDelegation() {
            this.init();
        }

        void init() {
            this.factoryMap = new HashMap<ProjectType, BPMNGraphFactory>();
            this.factoryMap.put(ProjectType.CASE, (BPMNGraphFactory)BPMNDelegateGraphFactory.this.caseGraphFactory);
            this.factoryMap.put(ProjectType.BPMN, (BPMNGraphFactory)BPMNDelegateGraphFactory.this.bpmnGraphFactory);
        }

        BPMNGraphFactory get(Optional<ProjectType> projectType) {
            return projectType.map(this.factoryMap::get).orElse((BPMNGraphFactory)BPMNDelegateGraphFactory.this.bpmnGraphFactory);
        }
    }
}

