/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser;

import java.text.ParseException;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.ArrayUtils;

public class ParsingUtils {
    public static String parseJavaName(String token, int startIndex, char[] stopCharacters) throws ParseException {
        char currentChar;
        if (startIndex < 0 || startIndex >= token.length()) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + " exceeds token bounds: " + token);
        }
        StringBuilder javaName = new StringBuilder();
        for (int currentIndex = startIndex; currentIndex < token.length() && !ArrayUtils.contains((char[])stopCharacters, (char)(currentChar = token.charAt(currentIndex))); ++currentIndex) {
            javaName.append(currentChar);
        }
        if (javaName.length() == 0) {
            throw new ParseException("Expected java name was not found at position: " + startIndex, startIndex);
        }
        if (!SourceVersion.isName(javaName)) {
            throw new ParseException("Invalid java name was found at position: " + startIndex, startIndex);
        }
        return javaName.toString();
    }
}

