/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindRuleFlowNamesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.RuleFlowGroup;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@ApplicationScoped
public class RuleFlowGroupQueryService {
    private final RefactoringQueryService queryService;
    private final Function<List<RefactoringPageRow>, List<RuleFlowGroup>> resultToSelectorData;
    public static final Function<List<RefactoringPageRow>, List<RuleFlowGroup>> DEFAULT_RESULT_CONVERTER = rows -> rows.stream().map(RuleFlowGroupQueryService::getValue).filter(Objects::nonNull).collect(Collectors.toList());

    public RuleFlowGroupQueryService() {
        this(null);
    }

    @Inject
    public RuleFlowGroupQueryService(RefactoringQueryService queryService) {
        this(queryService, DEFAULT_RESULT_CONVERTER);
    }

    RuleFlowGroupQueryService(RefactoringQueryService queryService, Function<List<RefactoringPageRow>, List<RuleFlowGroup>> resultToSelectorData) {
        this.queryService = queryService;
        this.resultToSelectorData = resultToSelectorData;
    }

    public List<RuleFlowGroup> getRuleFlowGroupNames() {
        List queryResult = this.queryService.query(FindRuleFlowNamesQuery.NAME, new Sets.Builder().add((Object)new ValueSharedPartIndexTerm("*", PartType.RULEFLOW_GROUP, ValueIndexTerm.TermSearchType.WILDCARD)).build());
        return this.resultToSelectorData.apply(queryResult);
    }

    private static RuleFlowGroup getValue(RefactoringPageRow row) {
        Map values = (Map)row.getValue();
        String name = (String)values.get("name");
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        RuleFlowGroup group = new RuleFlowGroup(name);
        group.setFileName((String)values.get("filename"));
        group.setPathUri((String)values.get("pathuri"));
        return group;
    }
}

