/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.lang.reflect.Modifier;
import java.util.Map;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectSource;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaEnumImpl;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDataModelOracleUtils {
    private static final Logger logger = LoggerFactory.getLogger(ModuleDataModelOracleUtils.class);

    public static void loadExternalDependencies(DataModel dataModel, ModuleDataModelOracle moduleDataModelOracle, ClassLoader classLoader) throws ModelDriverException {
        String[] factTypes = DataModelOracleUtilities.getFactTypes((ModuleDataModelOracle)moduleDataModelOracle);
        if (factTypes != null) {
            for (int i = 0; i < factTypes.length; ++i) {
                ObjectSource source = ModuleDataModelOracleUtils.factSource(moduleDataModelOracle, factTypes[i]);
                if (source == null || !ObjectSource.DEPENDENCY.equals((Object)source)) continue;
                ModuleDataModelOracleUtils.addType(dataModel, moduleDataModelOracle, factTypes[i], classLoader);
            }
        }
    }

    private static void addType(DataModel dataModel, ModuleDataModelOracle oracleDataModel, String factType, ClassLoader classLoader) throws ModelDriverException {
        ClassMetadata classMetadata = ModuleDataModelOracleUtils.readClassMetadata(factType, classLoader);
        if (!(classMetadata == null || classMetadata.isMemberClass() || classMetadata.isAnonymousClass() || classMetadata.isLocalClass())) {
            if (classMetadata.isEnumClass()) {
                ModuleDataModelOracleUtils.addEnumType(dataModel, factType, classMetadata);
            } else {
                ModuleDataModelOracleUtils.addDataObjectType(dataModel, oracleDataModel, factType, classMetadata);
            }
        }
    }

    private static void addDataObjectType(DataModel dataModel, ModuleDataModelOracle oracleDataModel, String factType, ClassMetadata classMetadata) throws ModelDriverException {
        String superClass = DataModelOracleUtilities.getSuperType((ModuleDataModelOracle)oracleDataModel, (String)factType);
        Visibility visibility = DriverUtils.buildVisibility(classMetadata.getModifiers());
        logger.debug("Adding dataObjectType: " + factType + ", to dataModel: " + dataModel + ", from oracleDataModel: " + oracleDataModel);
        DataObject dataObject = dataModel.addDataObject(factType, visibility, Modifier.isAbstract(classMetadata.getModifiers()), Modifier.isFinal(classMetadata.getModifiers()), ObjectSource.DEPENDENCY);
        dataObject.setSuperClassName(superClass);
        Map fields = oracleDataModel.getModuleModelFields();
        if (fields != null) {
            ModelField[] factFields = (ModelField[])fields.get(factType);
            if (factFields != null && factFields.length > 0) {
                for (int j = 0; j < factFields.length; ++j) {
                    ModelField field = factFields[j];
                    if (!ModuleDataModelOracleUtils.isLoadableField(field)) continue;
                    if (field.getType().equals("Collection")) {
                        String bag = DataModelOracleUtilities.getFieldClassName((ModuleDataModelOracle)oracleDataModel, (String)factType, (String)field.getName());
                        String itemsClass = DataModelOracleUtilities.getParametricFieldType((ModuleDataModelOracle)oracleDataModel, (String)factType, (String)field.getName());
                        if (itemsClass == null) {
                            dataObject.addProperty(field.getName(), bag);
                            continue;
                        }
                        dataObject.addProperty(field.getName(), itemsClass, true, bag);
                        continue;
                    }
                    dataObject.addProperty(field.getName(), field.getClassName());
                }
            }
        } else {
            logger.debug("No fields found for factTye: " + factType);
        }
    }

    private static void addEnumType(DataModel dataModel, String factType, ClassMetadata classMetadata) {
        String packageName = NamingUtils.extractPackageName(factType);
        String className = NamingUtils.extractClassName(factType);
        Visibility visibility = DriverUtils.buildVisibility(classMetadata.getModifiers());
        JavaEnumImpl javaEnum = new JavaEnumImpl(packageName, className, visibility);
        dataModel.addJavaEnum(javaEnum, ObjectSource.DEPENDENCY);
    }

    private static ClassMetadata readClassMetadata(String factType, ClassLoader classLoader) {
        try {
            Class<?> _class = classLoader.loadClass(factType);
            return new ClassMetadata(_class.getModifiers(), _class.isMemberClass(), _class.isLocalClass(), _class.isAnonymousClass(), _class.isEnum());
        }
        catch (ClassNotFoundException e) {
            logger.error("It was not possible to read class metadata for class: " + factType);
            return null;
        }
    }

    private static ObjectSource factSource(ModuleDataModelOracle oracleDataModel, String factType) {
        TypeSource oracleType = DataModelOracleUtilities.getTypeSource((ModuleDataModelOracle)oracleDataModel, (String)factType);
        if (TypeSource.JAVA_PROJECT.equals((Object)oracleType)) {
            return ObjectSource.INTERNAL;
        }
        if (TypeSource.JAVA_DEPENDENCY.equals((Object)oracleType)) {
            return ObjectSource.DEPENDENCY;
        }
        return null;
    }

    private static boolean isLoadableField(ModelField field) {
        return field.getOrigin().equals((Object)ModelField.FIELD_ORIGIN.DECLARED);
    }

    static class ClassMetadata {
        int modifiers;
        boolean memberClass;
        boolean localClass;
        boolean anonymousClass;
        boolean enumClass;

        public ClassMetadata(int modifiers, boolean memberClass, boolean localClass, boolean anonymousClass, boolean enumClass) {
            this.modifiers = modifiers;
            this.memberClass = memberClass;
            this.localClass = localClass;
            this.anonymousClass = anonymousClass;
            this.enumClass = enumClass;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public boolean isMemberClass() {
            return this.memberClass;
        }

        public void setMemberClass(boolean memberClass) {
            this.memberClass = memberClass;
        }

        public boolean isLocalClass() {
            return this.localClass;
        }

        public void setLocalClass(boolean localClass) {
            this.localClass = localClass;
        }

        public boolean isAnonymousClass() {
            return this.anonymousClass;
        }

        public void setAnonymousClass(boolean anonymousClass) {
            this.anonymousClass = anonymousClass;
        }

        public boolean isEnumClass() {
            return this.enumClass;
        }

        public void setEnumClass(boolean enumClass) {
            this.enumClass = enumClass;
        }
    }
}

