/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindAllLibraryAssetsQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryValueFileExtensionIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryValueRepositoryRootIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class FileLoader {
    @Inject
    private RefactoringQueryService refactoringQueryService;

    public List<org.uberfire.backend.vfs.Path> loadPaths(org.uberfire.backend.vfs.Path path, String suffix) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"suffix", (Object)suffix);
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        ArrayList<org.uberfire.backend.vfs.Path> items = new ArrayList<org.uberfire.backend.vfs.Path>();
        if (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            return items;
        }
        if (!Files.isDirectory((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            nioPath = nioPath.getParent();
        }
        HashSet<Object> queryTerms = new HashSet<Object>();
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(suffix);
        queryTerms.add(new LibraryValueRepositoryRootIndexTerm(Paths.convert((Path)nioPath).toURI(), ValueIndexTerm.TermSearchType.NORMAL));
        queryTerms.add(new LibraryValueFileExtensionIndexTerm(extensions));
        List rows = this.refactoringQueryService.query(FindAllLibraryAssetsQuery.NAME, queryTerms);
        for (RefactoringPageRow row : rows) {
            items.add((org.uberfire.backend.vfs.Path)row.getValue());
        }
        return items;
    }
}

